/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.s3.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import org.springframework.content.commons.io.RangeableResource;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.WritableResource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.support.ExecutorServiceAdapter;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetUrlRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.utils.BinaryUtils;

public class SimpleStorageResource
extends AbstractResource
implements WritableResource,
RangeableResource {
    private final String bucketName;
    private final String objectName;
    private final String versionId;
    private final S3Client amazonS3;
    private final TaskExecutor taskExecutor;
    private volatile HeadObjectResponse objectMetadata;
    private String range;
    private String contentType;

    public SimpleStorageResource(S3Client amazonS3, String bucketName, String objectName, TaskExecutor taskExecutor) {
        this(amazonS3, bucketName, objectName, taskExecutor, null, null);
    }

    public SimpleStorageResource(S3Client amazonS3, String bucketName, String objectName, TaskExecutor taskExecutor, String versionId) {
        this(amazonS3, bucketName, objectName, taskExecutor, versionId, null);
    }

    public SimpleStorageResource(S3Client amazonS3, String bucketName, String objectName, TaskExecutor taskExecutor, String versionId, String contentType) {
        this.amazonS3 = amazonS3;
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.taskExecutor = taskExecutor;
        this.versionId = versionId;
        this.contentType = contentType;
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder("Amazon s3 resource [bucket='");
        builder.append(this.bucketName);
        builder.append("' and object='");
        builder.append(this.objectName);
        if (this.versionId != null) {
            builder.append("' and versionId='");
            builder.append(this.versionId);
        }
        builder.append("']");
        return builder.toString();
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String contentType() throws IOException {
        return this.getRequiredObjectMetadata().contentType();
    }

    public void setRange(String range) {
        this.range = range;
    }

    public InputStream getInputStream() throws IOException {
        GetObjectRequest.Builder getObjectRequestBuilder = GetObjectRequest.builder().bucket(this.bucketName).key(this.objectName);
        if (this.versionId != null) {
            getObjectRequestBuilder.versionId(this.versionId);
        }
        if (this.range != null) {
            getObjectRequestBuilder.range(this.range);
            return new PartialContentInputStream((InputStream)this.amazonS3.getObject((GetObjectRequest)getObjectRequestBuilder.build()));
        }
        return this.amazonS3.getObject((GetObjectRequest)getObjectRequestBuilder.build());
    }

    public boolean exists() {
        return this.getObjectMetadata() != null;
    }

    public long contentLength() throws IOException {
        return this.getRequiredObjectMetadata().contentLength();
    }

    public long lastModified() throws IOException {
        return this.getRequiredObjectMetadata().lastModified().getEpochSecond();
    }

    public String getFilename() throws IllegalStateException {
        return this.objectName;
    }

    public URL getURL() {
        return this.amazonS3.utilities().getUrl((GetUrlRequest)GetUrlRequest.builder().bucket(this.bucketName).key(this.objectName).build());
    }

    public File getFile() throws IOException {
        throw new UnsupportedOperationException("Amazon S3 resource can not be resolved to java.io.File objects.Use getInputStream() to retrieve the contents of the object!");
    }

    private HeadObjectResponse getRequiredObjectMetadata() throws FileNotFoundException {
        HeadObjectResponse metadata = this.getObjectMetadata();
        if (metadata == null) {
            StringBuilder builder = new StringBuilder().append("Resource with bucket='").append(this.bucketName).append("' and objectName='").append(this.objectName);
            if (this.versionId != null) {
                builder.append("' and versionId='");
                builder.append(this.versionId);
            }
            builder.append("' not found!");
            throw new FileNotFoundException(builder.toString());
        }
        return metadata;
    }

    public boolean isWritable() {
        return true;
    }

    public OutputStream getOutputStream() throws IOException {
        return new SimpleStorageOutputStream();
    }

    public SimpleStorageResource createRelative(String relativePath) throws IOException {
        String relativeKey = this.objectName + "/" + relativePath;
        return new SimpleStorageResource(this.amazonS3, this.bucketName, relativeKey, this.taskExecutor);
    }

    private HeadObjectResponse getObjectMetadata() {
        if (this.objectMetadata == null) {
            try {
                HeadObjectRequest.Builder headObjectRequestBuilder = HeadObjectRequest.builder().bucket(this.bucketName).key(this.objectName);
                if (this.versionId != null) {
                    headObjectRequestBuilder.versionId(this.versionId);
                }
                this.objectMetadata = this.amazonS3.headObject((HeadObjectRequest)headObjectRequestBuilder.build());
            }
            catch (S3Exception e) {
                if (e.statusCode() == 404 || e.statusCode() == 301) {
                    this.objectMetadata = null;
                }
                throw e;
            }
        }
        return this.objectMetadata;
    }

    public static class PartialContentInputStream
    extends InputStream {
        private InputStream delegate;

        public PartialContentInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public long skip(long n) throws IOException {
            return n;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }

    private class SimpleStorageOutputStream
    extends OutputStream {
        private static final int BUFFER_SIZE = 0x500000;
        private final Object monitor = new Object();
        private final CompletionService<CompletedPart> completionService;
        private ByteArrayOutputStream currentOutputStream = new ByteArrayOutputStream(0x500000);
        private int partNumberCounter = 1;
        private CreateMultipartUploadResponse multiPartUploadResult;

        SimpleStorageOutputStream() {
            this.completionService = new ExecutorCompletionService<CompletedPart>((Executor)new ExecutorServiceAdapter(SimpleStorageResource.this.taskExecutor));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            Object object = this.monitor;
            synchronized (object) {
                if (this.currentOutputStream.size() == 0x500000) {
                    this.initiateMultiPartIfNeeded();
                    this.completionService.submit(new UploadPartResultCallable(SimpleStorageResource.this.amazonS3, this.currentOutputStream.toByteArray(), this.currentOutputStream.size(), SimpleStorageResource.this.bucketName, SimpleStorageResource.this.objectName, this.multiPartUploadResult.uploadId(), this.partNumberCounter++));
                    this.currentOutputStream.reset();
                }
                this.currentOutputStream.write(b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.monitor;
            synchronized (object) {
                if (this.currentOutputStream == null) {
                    return;
                }
                if (this.isMultiPartUpload()) {
                    this.finishMultiPartUpload();
                } else {
                    this.finishSimpleUpload();
                }
            }
        }

        private boolean isMultiPartUpload() {
            return this.multiPartUploadResult != null;
        }

        private void finishSimpleUpload() {
            String md5Digest;
            byte[] content = this.currentOutputStream.toByteArray();
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                md5Digest = BinaryUtils.toBase64((byte[])messageDigest.digest(content));
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("MessageDigest could not be initialized because it uses an unknown algorithm", e);
            }
            PutObjectRequest.Builder requestBuilder = PutObjectRequest.builder().bucket(SimpleStorageResource.this.bucketName).key(SimpleStorageResource.this.objectName).contentMD5(md5Digest);
            if (SimpleStorageResource.this.contentType != null) {
                requestBuilder.contentType(SimpleStorageResource.this.contentType);
            }
            SimpleStorageResource.this.amazonS3.putObject((PutObjectRequest)requestBuilder.build(), RequestBody.fromBytes((byte[])content));
            this.currentOutputStream = null;
        }

        private void finishMultiPartUpload() throws IOException {
            this.completionService.submit(new UploadPartResultCallable(SimpleStorageResource.this.amazonS3, this.currentOutputStream.toByteArray(), this.currentOutputStream.size(), SimpleStorageResource.this.bucketName, SimpleStorageResource.this.objectName, this.multiPartUploadResult.uploadId(), this.partNumberCounter));
            try {
                CompletedMultipartUpload multipartUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(this.getCompletedMultiParts()).build();
                SimpleStorageResource.this.amazonS3.completeMultipartUpload((CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(this.multiPartUploadResult.bucket()).key(this.multiPartUploadResult.key()).multipartUpload(multipartUpload).uploadId(this.multiPartUploadResult.uploadId()).build());
            }
            catch (ExecutionException e) {
                this.abortMultiPartUpload();
                throw new IOException("Multi part upload failed ", e.getCause());
            }
            catch (InterruptedException e) {
                this.abortMultiPartUpload();
                Thread.currentThread().interrupt();
            }
            finally {
                this.currentOutputStream = null;
            }
        }

        private void initiateMultiPartIfNeeded() {
            if (this.multiPartUploadResult == null) {
                CreateMultipartUploadRequest.Builder requestBuilder = CreateMultipartUploadRequest.builder().bucket(SimpleStorageResource.this.bucketName).key(SimpleStorageResource.this.objectName);
                if (SimpleStorageResource.this.contentType != null) {
                    requestBuilder.contentType(SimpleStorageResource.this.contentType);
                }
                this.multiPartUploadResult = SimpleStorageResource.this.amazonS3.createMultipartUpload((CreateMultipartUploadRequest)requestBuilder.build());
            }
        }

        private void abortMultiPartUpload() {
            if (this.isMultiPartUpload()) {
                SimpleStorageResource.this.amazonS3.abortMultipartUpload((AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(this.multiPartUploadResult.bucket()).key(this.multiPartUploadResult.key()).uploadId(this.multiPartUploadResult.uploadId()).build());
            }
        }

        private List<CompletedPart> getCompletedMultiParts() throws ExecutionException, InterruptedException {
            ArrayList<CompletedPart> result = new ArrayList<CompletedPart>(this.partNumberCounter);
            for (int i = 0; i < this.partNumberCounter; ++i) {
                Future<CompletedPart> uploadPartResultFuture = this.completionService.take();
                result.add(uploadPartResultFuture.get());
            }
            return result;
        }

        private final class UploadPartResultCallable
        implements Callable<CompletedPart> {
            private final S3Client amazonS3;
            private final int contentLength;
            private final int partNumber;
            private final String bucketName;
            private final String key;
            private final String uploadId;
            private byte[] content;

            private UploadPartResultCallable(S3Client amazon, byte[] content, int writtenDataSize, String bucketName, String key, String uploadId, int partNumber) {
                this.amazonS3 = amazon;
                this.content = content;
                this.contentLength = writtenDataSize;
                this.partNumber = partNumber;
                this.bucketName = bucketName;
                this.key = key;
                this.uploadId = uploadId;
            }

            @Override
            public CompletedPart call() throws Exception {
                try {
                    UploadPartResponse uploadPartResponse = this.amazonS3.uploadPart((UploadPartRequest)UploadPartRequest.builder().bucket(this.bucketName).key(this.key).uploadId(this.uploadId).partNumber(Integer.valueOf(this.partNumber)).build(), RequestBody.fromInputStream((InputStream)new ByteArrayInputStream(this.content), (long)this.contentLength));
                    CompletedPart completedPart = (CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(this.partNumber)).eTag(uploadPartResponse.eTag()).build();
                    return completedPart;
                }
                finally {
                    this.content = null;
                }
            }
        }
    }
}

