/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.s3.store;

import internal.org.springframework.content.commons.utils.ContentPropertyInfoTypeDescriptor;
import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.content.commons.config.ContentPropertyInfo;
import org.springframework.content.commons.mappingcontext.Condition;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.repository.ReactiveContentStore;
import org.springframework.content.commons.store.StoreAccessException;
import org.springframework.content.commons.utils.PlacementService;
import org.springframework.content.s3.S3ObjectId;
import org.springframework.content.s3.config.MultiTenantS3ClientProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.io.ResourceLoader;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.ResponsePublisher;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

@Transactional
public class DefaultReactiveS3StoreImpl<S, SID extends Serializable>
implements ReactiveContentStore<S, SID>,
org.springframework.content.commons.store.ReactiveContentStore<S, SID> {
    private static Log logger = LogFactory.getLog(DefaultReactiveS3StoreImpl.class);
    private ApplicationContext context;
    private ResourceLoader loader;
    private PlacementService placementService;
    private MultiTenantS3ClientProvider clientProvider;
    private MappingContext mappingContext;
    private S3AsyncClient asyncClient;

    public DefaultReactiveS3StoreImpl(ApplicationContext context, ResourceLoader loader, MappingContext mappingContext, PlacementService placementService, S3AsyncClient asyncClient, MultiTenantS3ClientProvider provider) {
        Assert.notNull((Object)context, (String)"context must be specified");
        Assert.notNull((Object)loader, (String)"loader must be specified");
        Assert.notNull((Object)placementService, (String)"placementService must be specified");
        this.context = context;
        this.loader = loader;
        this.placementService = placementService;
        this.asyncClient = asyncClient;
        this.clientProvider = provider;
        this.mappingContext = mappingContext;
        if (this.mappingContext == null) {
            this.mappingContext = new MappingContext((CharSequence)"/", (CharSequence)".");
        }
    }

    private S3ObjectId getS3ObjectId(S entity, PropertyPath path, ContentProperty property) {
        TypeDescriptor contentPropertyInfoType = ContentPropertyInfoTypeDescriptor.withGenerics(entity, (ContentProperty)property);
        if (!this.placementService.canConvert(contentPropertyInfoType, TypeDescriptor.valueOf(S3ObjectId.class))) {
            throw new IllegalStateException(String.format("Unable to convert %s to an S3ObjectId", contentPropertyInfoType));
        }
        ContentPropertyInfo contentPropertyInfo = ContentPropertyInfo.of(entity, (Serializable)((Serializable)property.getContentId(entity)), (PropertyPath)path, (ContentProperty)property);
        S3ObjectId s3ObjectId = (S3ObjectId)this.placementService.convert((Object)contentPropertyInfo, S3ObjectId.class);
        return s3ObjectId;
    }

    @Transactional
    public Mono<S> setContent(S entity, PropertyPath path, long contentLen, Flux<ByteBuffer> buffer) {
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), path.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", path.getName()));
        }
        Object contentId = property.getContentId(entity);
        if (contentId == null) {
            String newId = UUID.randomUUID().toString();
            Object convertedId = this.placementService.convert((Object)newId, TypeDescriptor.forObject((Object)newId), property.getContentIdType(entity));
            property.setContentId(entity, convertedId, null);
            contentId = convertedId;
        }
        S3ObjectId s3ObjectId = this.getS3ObjectId(entity, path, property);
        PutObjectRequest.Builder requestBuilder = PutObjectRequest.builder().bucket(s3ObjectId.getBucket()).contentLength(Long.valueOf(contentLen)).key(s3ObjectId.getKey());
        Object mimeType = property.getMimeType(entity);
        if (mimeType != null) {
            String strMimeType = mimeType.toString();
            requestBuilder.contentType(strMimeType);
        }
        CompletableFuture future = this.asyncClient.putObject((PutObjectRequest)requestBuilder.build(), AsyncRequestBody.fromPublisher(buffer));
        return Mono.fromFuture((CompletableFuture)future).map(response -> {
            property.setContentId(entity, (Object)s3ObjectId.getKey(), null);
            property.setContentLength(entity, (Object)contentLen);
            return entity;
        });
    }

    public Flux<ByteBuffer> getContent(S entity, PropertyPath path) {
        if (entity == null) {
            return Flux.empty();
        }
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), path.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", path.getName()));
        }
        Object contentId = property.getContentId(entity);
        if (contentId == null) {
            return Flux.empty();
        }
        S3ObjectId s3ObjectId = this.getS3ObjectId(entity, path, property);
        GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(s3ObjectId.getBucket()).key(s3ObjectId.getKey()).build();
        AsyncResponseTransformer.toFile((File)new File("/tmp/foo"));
        CompletableFuture responseFuture = this.asyncClient.getObject(request, AsyncResponseTransformer.toPublisher());
        ResponsePublisher responsePublisher = (ResponsePublisher)responseFuture.join();
        return Flux.from((Publisher)responsePublisher);
    }

    @Transactional
    public Mono<S> unsetContent(S entity, PropertyPath propertyPath) {
        if (entity == null) {
            return Mono.just(entity);
        }
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        Object contentId = property.getContentId(entity);
        if (contentId == null) {
            return Mono.just(entity);
        }
        S3ObjectId s3ObjectId = this.getS3ObjectId(entity, propertyPath, property);
        DeleteObjectRequest deleteRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(s3ObjectId.getBucket()).key(s3ObjectId.getKey()).build();
        CompletableFuture future = this.asyncClient.deleteObject(deleteRequest);
        return Mono.fromFuture((CompletableFuture)future).map(response -> {
            property.setContentId(entity, null, new Condition(){

                public boolean matches(TypeDescriptor descriptor) {
                    for (Annotation annotation : descriptor.getAnnotations()) {
                        if (!"jakarta.persistence.Id".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.data.annotation.Id".equals(annotation.annotationType().getCanonicalName())) continue;
                        return false;
                    }
                    return true;
                }
            });
            property.setContentLength(entity, (Object)0);
            return entity;
        });
    }
}

