/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.s3.store;

import internal.org.springframework.content.commons.utils.ContentPropertyInfoTypeDescriptor;
import internal.org.springframework.content.s3.io.S3StoreResource;
import internal.org.springframework.content.s3.io.SimpleStorageProtocolResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.annotations.ContentLength;
import org.springframework.content.commons.annotations.MimeType;
import org.springframework.content.commons.config.ContentPropertyInfo;
import org.springframework.content.commons.io.DeletableResource;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.store.GetResourceParams;
import org.springframework.content.commons.store.StoreAccessException;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.commons.utils.Condition;
import org.springframework.content.commons.utils.PlacementService;
import org.springframework.content.s3.S3ObjectId;
import org.springframework.content.s3.config.MultiTenantS3ClientProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.WritableResource;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.s3.S3Client;

@Transactional
public class DefaultS3StoreImpl<S, SID extends Serializable>
implements Store<SID>,
AssociativeStore<S, SID>,
ContentStore<S, SID>,
org.springframework.content.commons.store.AssociativeStore<S, SID> {
    private static Log logger = LogFactory.getLog(DefaultS3StoreImpl.class);
    private ApplicationContext context;
    private ResourceLoader loader;
    private PlacementService placementService;
    private S3Client client;
    private MultiTenantS3ClientProvider clientProvider;
    private MappingContext mappingContext;

    public DefaultS3StoreImpl(ApplicationContext context, ResourceLoader loader, MappingContext mappingContext, PlacementService placementService, S3Client client, MultiTenantS3ClientProvider provider) {
        Assert.notNull((Object)context, (String)"context must be specified");
        Assert.notNull((Object)loader, (String)"loader must be specified");
        Assert.notNull((Object)placementService, (String)"placementService must be specified");
        Assert.notNull((Object)client, (String)"client must be specified");
        this.context = context;
        this.loader = loader;
        this.placementService = placementService;
        this.client = client;
        this.clientProvider = provider;
        this.mappingContext = mappingContext;
        if (this.mappingContext == null) {
            this.mappingContext = new MappingContext((CharSequence)"/", (CharSequence)".");
        }
    }

    public Resource getResource(SID id) {
        if (id == null) {
            return null;
        }
        if (!(id instanceof S3ObjectId)) {
            S3ObjectId s3ObjectId = null;
            if (this.placementService.canConvert(id.getClass(), S3ObjectId.class)) {
                s3ObjectId = (S3ObjectId)this.placementService.convert(id, S3ObjectId.class);
                return this.getResourceInternal(s3ObjectId, GetResourceParams.builder().build());
            }
            throw new StoreAccessException(String.format("Unable to convert from %s to S3ObjectId", id));
        }
        return this.getResourceInternal((S3ObjectId)id, GetResourceParams.builder().build());
    }

    public Resource getResource(S entity) {
        if (entity == null) {
            return null;
        }
        Serializable contentId = (Serializable)BeanUtils.getFieldWithAnnotation(entity, ContentId.class);
        if (contentId == null) {
            return null;
        }
        S3ObjectId s3ObjectId = null;
        if (this.placementService.canConvert(entity.getClass(), S3ObjectId.class) && (s3ObjectId = (S3ObjectId)this.placementService.convert(entity, S3ObjectId.class)) != null) {
            return this.getResourceInternal(s3ObjectId, GetResourceParams.builder().build());
        }
        return this.getResource((S)contentId);
    }

    public Resource getResource(S entity, PropertyPath propertyPath) {
        return this.getResource(entity, propertyPath, GetResourceParams.builder().build());
    }

    public Resource getResource(S entity, PropertyPath propertyPath, GetResourceParams params) {
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        if (entity == null) {
            return null;
        }
        if (property.getContentId(entity) == null) {
            return null;
        }
        S3ObjectId s3ObjectId = null;
        TypeDescriptor contentPropertyInfoType = ContentPropertyInfoTypeDescriptor.withGenerics(entity, (ContentProperty)property);
        if (this.placementService.canConvert(contentPropertyInfoType, TypeDescriptor.valueOf(S3ObjectId.class))) {
            ContentPropertyInfo contentPropertyInfo = ContentPropertyInfo.of(entity, (Serializable)((Serializable)property.getContentId(entity)), (PropertyPath)propertyPath, (ContentProperty)property);
            s3ObjectId = (S3ObjectId)this.placementService.convert((Object)contentPropertyInfo, S3ObjectId.class);
            Resource r = this.getResourceInternal(s3ObjectId, params);
            return r;
        }
        Serializable contentId = (Serializable)property.getContentId(entity);
        return this.getResource((S)contentId);
    }

    public Resource getResource(S entity, PropertyPath propertyPath, org.springframework.content.commons.repository.GetResourceParams params) {
        return this.getResource(entity, propertyPath, GetResourceParams.builder().range(params.getRange()).build());
    }

    protected Resource getResourceInternal(S3ObjectId id, GetResourceParams params) {
        S3Client client;
        String bucket = id.getBucket();
        String location = null;
        if (this.placementService.canConvert(S3ObjectId.class, String.class)) {
            location = (String)this.placementService.convert((Object)id, String.class);
            location = this.absolutify(bucket, location);
        } else {
            String objectId = id.getKey();
            location = (String)this.placementService.convert((Object)objectId, String.class);
            location = this.absolutify(bucket, location);
        }
        S3Client clientToUse = this.client;
        ResourceLoader loaderToUse = this.loader;
        if (this.clientProvider != null && (client = this.clientProvider.getS3Client()) != null) {
            SimpleStorageProtocolResolver s3Protocol = new SimpleStorageProtocolResolver(client);
            s3Protocol.afterPropertiesSet();
            DefaultResourceLoader loader = new DefaultResourceLoader();
            loader.addProtocolResolver((ProtocolResolver)s3Protocol);
            clientToUse = client;
            loaderToUse = loader;
        }
        Resource resource = loaderToUse.getResource(location);
        S3StoreResource s3Resource = new S3StoreResource(clientToUse, bucket, resource);
        s3Resource.setRange(params.getRange());
        return s3Resource;
    }

    public void associate(Object entity, Serializable id) {
        BeanUtils.setFieldWithAnnotation((Object)entity, ContentId.class, (Object)id);
    }

    public void associate(S entity, PropertyPath propertyPath, SID id) {
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        property.setContentId(entity, id, null);
    }

    public void unassociate(Object entity) {
        BeanUtils.setFieldWithAnnotationConditionally((Object)entity, ContentId.class, null, (Condition)new Condition(){

            public boolean matches(Field field) {
                for (Annotation annotation : field.getAnnotations()) {
                    if (!"jakarta.persistence.Id".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.data.annotation.Id".equals(annotation.annotationType().getCanonicalName())) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public void unassociate(S entity, PropertyPath propertyPath) {
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        property.setContentId(entity, null, new org.springframework.content.commons.mappingcontext.Condition(){

            public boolean matches(TypeDescriptor descriptor) {
                for (Annotation annotation : descriptor.getAnnotations()) {
                    if (!"jakarta.persistence.Id".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.data.annotation.Id".equals(annotation.annotationType().getCanonicalName())) continue;
                    return false;
                }
                return true;
            }
        });
    }

    private void setResourceContentTypeFromMimeType(S entity, ContentProperty property, Resource resource) {
        Object mimeType;
        if (resource instanceof S3StoreResource && (mimeType = property == null ? BeanUtils.getFieldWithAnnotation(entity, MimeType.class) : property.getMimeType(entity)) != null) {
            String strMimeType = mimeType.toString();
            S3StoreResource s3StoreResource = (S3StoreResource)resource;
            s3StoreResource.setContentType(strMimeType);
        }
    }

    @Transactional
    public S setContent(S entity, InputStream content) {
        Resource resource;
        Object contentId = BeanUtils.getFieldWithAnnotation(entity, ContentId.class);
        if (contentId == null) {
            String newId = UUID.randomUUID().toString();
            Object convertedId = this.placementService.convert((Object)newId, TypeDescriptor.forObject((Object)newId), TypeDescriptor.valueOf((Class)BeanUtils.getFieldWithAnnotationType(entity, ContentId.class)));
            BeanUtils.setFieldWithAnnotation(entity, ContentId.class, (Object)convertedId);
        }
        if ((resource = this.getResource(entity)) == null) {
            return entity;
        }
        this.setResourceContentTypeFromMimeType(entity, null, resource);
        if (resource instanceof WritableResource) {
            try (OutputStream os = ((WritableResource)resource).getOutputStream();){
                IOUtils.copy((InputStream)content, (OutputStream)os);
            }
            catch (IOException e) {
                logger.error((Object)String.format("Unexpected error setting content for entity %s", entity), (Throwable)e);
                throw new StoreAccessException(String.format("Setting content for entity %s", entity), (Throwable)e);
            }
        }
        try {
            BeanUtils.setFieldWithAnnotation(entity, ContentLength.class, (Object)resource.contentLength());
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error setting content length for entity %s", entity), (Throwable)e);
        }
        return entity;
    }

    @Transactional
    public S setContent(S entity, PropertyPath propertyPath, InputStream content) {
        return this.setContent(entity, propertyPath, content, -1L);
    }

    @Transactional
    public S setContent(S entity, PropertyPath propertyPath, InputStream content, long contentLen) {
        Resource resource;
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        Object contentId = property.getContentId(entity);
        if (contentId == null) {
            String newId = UUID.randomUUID().toString();
            Object convertedId = this.placementService.convert((Object)newId, TypeDescriptor.forObject((Object)newId), property.getContentIdType(entity));
            property.setContentId(entity, convertedId, null);
        }
        if ((resource = this.getResource(entity, propertyPath)) == null) {
            return entity;
        }
        this.setResourceContentTypeFromMimeType(entity, property, resource);
        if (resource instanceof WritableResource) {
            try (OutputStream os = ((WritableResource)resource).getOutputStream();){
                IOUtils.copy((InputStream)content, (OutputStream)os);
            }
            catch (IOException e) {
                logger.error((Object)String.format("Unexpected error setting content for entity %s", entity), (Throwable)e);
                throw new StoreAccessException(String.format("Setting content for entity %s", entity), (Throwable)e);
            }
        }
        try {
            long len = contentLen;
            if (len == -1L) {
                len = resource.contentLength();
            }
            property.setContentLength(entity, (Object)len);
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error setting content length for entity %s", entity), (Throwable)e);
        }
        return entity;
    }

    public S setContent(S property, Resource resourceContent) {
        try {
            return this.setContent(property, resourceContent.getInputStream());
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error setting content for entity %s", property), (Throwable)e);
            throw new StoreAccessException(String.format("Setting content for entity %s", property), (Throwable)e);
        }
    }

    public S setContent(S entity, PropertyPath propertyPath, Resource resourceContent) {
        try {
            return this.setContent(entity, propertyPath, resourceContent.getInputStream());
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error setting content for entity %s", entity), (Throwable)e);
            throw new StoreAccessException(String.format("Setting content for entity %s", entity), (Throwable)e);
        }
    }

    @Transactional
    public InputStream getContent(S entity) {
        if (entity == null) {
            return null;
        }
        Resource resource = this.getResource(entity);
        try {
            if (resource != null && resource.exists()) {
                return resource.getInputStream();
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error getting content for entity %s", entity), (Throwable)e);
            throw new StoreAccessException(String.format("Getting content for entity %s", entity), (Throwable)e);
        }
        return null;
    }

    @Transactional
    public InputStream getContent(S entity, PropertyPath propertyPath) {
        if (entity == null) {
            return null;
        }
        Resource resource = this.getResource(entity, propertyPath);
        try {
            if (resource != null && resource.exists()) {
                return resource.getInputStream();
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error getting content for entity %s", entity), (Throwable)e);
            throw new StoreAccessException(String.format("Getting content for entity %s", entity), (Throwable)e);
        }
        return null;
    }

    @Transactional
    public S unsetContent(S entity) {
        if (entity == null) {
            return entity;
        }
        this.deleteIfExists(entity);
        BeanUtils.setFieldWithAnnotationConditionally(entity, ContentId.class, null, (Condition)new Condition(){

            public boolean matches(Field field) {
                for (Annotation annotation : field.getAnnotations()) {
                    if (!"jakarta.persistence.Id".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.data.annotation.Id".equals(annotation.annotationType().getCanonicalName())) continue;
                    return false;
                }
                return true;
            }
        });
        BeanUtils.setFieldWithAnnotation(entity, ContentLength.class, (Object)0);
        return entity;
    }

    @Transactional
    public S unsetContent(S entity, PropertyPath propertyPath) {
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        if (entity == null) {
            return entity;
        }
        this.deleteIfExists(entity, propertyPath);
        property.setContentId(entity, null, new org.springframework.content.commons.mappingcontext.Condition(){

            public boolean matches(TypeDescriptor descriptor) {
                for (Annotation annotation : descriptor.getAnnotations()) {
                    if (!"jakarta.persistence.Id".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.data.annotation.Id".equals(annotation.annotationType().getCanonicalName())) continue;
                    return false;
                }
                return true;
            }
        });
        property.setContentLength(entity, (Object)0);
        return entity;
    }

    private String absolutify(String bucket, String location) {
        String locationToUse = null;
        Assert.state((!location.startsWith("s3://") ? 1 : 0) != 0);
        locationToUse = location.startsWith("/") ? location.substring(1) : location;
        return String.format("s3://%s/%s", bucket, locationToUse);
    }

    private void deleteIfExists(S entity) {
        Resource resource = this.getResource(entity);
        if (resource != null && resource.exists() && resource instanceof DeletableResource) {
            try {
                ((DeletableResource)resource).delete();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Unexpected error unsetting content for entity %s", entity));
                throw new StoreAccessException(String.format("Unsetting content for entity %s", entity), (Throwable)e);
            }
        }
    }

    private void deleteIfExists(S entity, PropertyPath path) {
        Resource resource = this.getResource(entity, path);
        if (resource != null && resource.exists() && resource instanceof DeletableResource) {
            try {
                ((DeletableResource)resource).delete();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Unexpected error unsetting content for entity %s", entity));
                throw new StoreAccessException(String.format("Unsetting content for entity %s", entity), (Throwable)e);
            }
        }
    }
}

