/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.s3;

import java.io.Serializable;

public class S3ObjectId
implements Serializable {
    private static String DEFAULT_INSTRUCTION_FILE_SUFFIX = "instruction";
    private static String DOT = ".";
    private final String bucket;
    private final String key;
    private final String versionId;

    public S3ObjectId(String bucket, String key) {
        this(bucket, key, null);
    }

    public S3ObjectId(String bucket, String key, String versionId) {
        if (bucket == null || key == null) {
            throw new IllegalArgumentException("bucket and key must be specified");
        }
        this.bucket = bucket;
        this.key = key;
        this.versionId = versionId;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String toString() {
        return "bucket: " + this.bucket + ", key: " + this.key + ", versionId: " + this.versionId;
    }
}

