/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.s3.config;

import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.repository.StoreAccessException;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.s3.Bucket;
import org.springframework.content.s3.S3ObjectIdResolver;

public class DefaultAssociativeStoreS3ObjectIdResolver
implements S3ObjectIdResolver<Object> {
    @Override
    public String getBucket(Object idOrEntity, String defaultBucketName) {
        Object bucket = BeanUtils.getFieldWithAnnotation((Object)idOrEntity, Bucket.class);
        if (bucket == null) {
            bucket = defaultBucketName;
        }
        if (bucket == null) {
            throw new StoreAccessException("Bucket not set");
        }
        return bucket.toString();
    }

    @Override
    public String getKey(Object idOrEntity) {
        if (BeanUtils.hasFieldWithAnnotation((Object)idOrEntity, ContentId.class)) {
            Object contentId = BeanUtils.getFieldWithAnnotation((Object)idOrEntity, ContentId.class);
            return contentId != null ? contentId.toString() : null;
        }
        return idOrEntity.toString();
    }
}

