/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.s3.config;

import com.amazonaws.services.s3.model.S3ObjectId;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.springframework.content.s3.S3ObjectIdResolver;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.Assert;

public class S3ObjectIdResolverConverter
implements GenericConverter {
    private final S3ObjectIdResolver resolver;
    private final String defaultBucket;
    private Class<?> fromType;

    public S3ObjectIdResolverConverter(S3ObjectIdResolver resolver, String defaultBucket) {
        this.resolver = resolver;
        this.defaultBucket = defaultBucket;
        this.fromType = this.getFromType(resolver);
        Assert.notNull(this.fromType, (String)String.format("Unable to determine type of S3ObjectIdResolver %s", resolver));
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(this.fromType, S3ObjectId.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        this.resolver.validate(source);
        String bucket = this.resolver.getBucket(source, this.defaultBucket);
        Assert.notNull((Object)bucket, (String)String.format("Unable to determine bucket from %s", source));
        String key = this.resolver.getKey(source);
        return key != null ? new S3ObjectId(bucket, key) : null;
    }

    protected Class<?> getFromType(S3ObjectIdResolver resolver) {
        Type[] types;
        if (resolver.getTarget() != null) {
            return resolver.getTarget();
        }
        Class fromType = null;
        for (Type t : types = resolver.getClass().getGenericInterfaces()) {
            ParameterizedType pt;
            Type[] typeArgs;
            if (!(t instanceof ParameterizedType) || (typeArgs = (pt = (ParameterizedType)t).getActualTypeArguments()).length != 1 || !(typeArgs[0] instanceof Class)) continue;
            fromType = (Class)typeArgs[0];
        }
        return fromType;
    }
}

