/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.s3.config;

import internal.org.springframework.content.s3.config.DefaultAssociativeStoreS3ObjectIdResolver;
import internal.org.springframework.content.s3.config.S3ObjectIdResolverConverter;
import internal.org.springframework.content.s3.config.S3StoreFactoryBean;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.content.commons.utils.PlacementService;
import org.springframework.content.commons.utils.PlacementServiceImpl;
import org.springframework.content.s3.S3ObjectIdResolver;
import org.springframework.content.s3.config.S3ObjectIdResolvers;
import org.springframework.content.s3.config.S3StoreConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;

@Configuration
public class S3StoreConfiguration {
    @Autowired(required=false)
    private List<S3StoreConfigurer> configurers;
    @Value(value="${spring.content.s3.bucket:#{environment.AWS_BUCKET}}")
    private String bucket;

    @Bean
    public S3ObjectIdResolvers contentIdResolvers() {
        S3ObjectIdResolvers resolvers = new S3ObjectIdResolvers();
        if (this.configurers != null) {
            for (S3StoreConfigurer configurer : this.configurers) {
                configurer.configureS3ObjectIdResolvers(resolvers);
            }
        }
        return resolvers;
    }

    @Bean
    public PlacementService s3StorePlacementService() {
        PlacementServiceImpl conversion = new PlacementServiceImpl();
        for (S3ObjectIdResolver resolver : this.contentIdResolvers()) {
            conversion.addConverter((GenericConverter)new S3ObjectIdResolverConverter(resolver, this.bucket));
        }
        S3StoreConfiguration.addDefaultS3ObjectIdConverters((PlacementService)conversion, this.bucket);
        this.addConverters((ConverterRegistry)conversion);
        return conversion;
    }

    public static void addDefaultS3ObjectIdConverters(PlacementService conversion, String bucket) {
        conversion.addConverter((GenericConverter)new S3ObjectIdResolverConverter(S3StoreFactoryBean.DEFAULT_S3OBJECTID_RESOLVER_STORE, bucket));
        conversion.addConverter((GenericConverter)new S3ObjectIdResolverConverter(new DefaultAssociativeStoreS3ObjectIdResolver(), bucket));
    }

    private void addConverters(ConverterRegistry registry) {
        if (this.configurers == null) {
            return;
        }
        for (S3StoreConfigurer configurer : this.configurers) {
            configurer.configureS3StoreConverters(registry);
        }
    }
}

