/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.s3.config;

import com.amazonaws.services.s3.AmazonS3;
import internal.org.springframework.content.s3.store.DefaultS3StoreImpl;
import java.io.Serializable;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.aws.core.io.s3.SimpleStorageProtocolResolver;
import org.springframework.content.commons.repository.factory.AbstractStoreFactoryBean;
import org.springframework.content.commons.utils.PlacementService;
import org.springframework.content.s3.S3ObjectIdResolver;
import org.springframework.content.s3.config.MultiTenantAmazonS3Provider;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.ResourceLoader;
import org.springframework.versions.LockingAndVersioningProxyFactory;

public class S3StoreFactoryBean
extends AbstractStoreFactoryBean {
    public static final S3ObjectIdResolver<Serializable> DEFAULT_S3OBJECTID_RESOLVER_STORE = S3ObjectIdResolver.createDefaultS3ObjectIdHelper();
    @Autowired
    private ApplicationContext context;
    @Autowired
    private AmazonS3 client;
    @Autowired
    private PlacementService s3StorePlacementService;
    @Autowired(required=false)
    private MultiTenantAmazonS3Provider s3Provider = null;
    @Autowired(required=false)
    private LockingAndVersioningProxyFactory versioning;
    @Value(value="${spring.content.s3.bucket:#{environment.AWS_BUCKET}}")
    private String bucket;

    public S3StoreFactoryBean() {
    }

    @Autowired
    public S3StoreFactoryBean(ApplicationContext context, AmazonS3 client, PlacementService s3StorePlacementService) {
        this.context = context;
        this.client = client;
        this.s3StorePlacementService = s3StorePlacementService;
    }

    protected void addProxyAdvice(ProxyFactory result, BeanFactory beanFactory) {
        if (this.versioning != null) {
            this.versioning.apply(result);
        }
    }

    protected Object getContentStoreImpl() {
        SimpleStorageProtocolResolver s3Protocol = new SimpleStorageProtocolResolver();
        s3Protocol.afterPropertiesSet();
        s3Protocol.setBeanFactory((BeanFactory)this.context);
        DefaultResourceLoader loader = new DefaultResourceLoader();
        loader.addProtocolResolver((ProtocolResolver)s3Protocol);
        return new DefaultS3StoreImpl(this.context, (ResourceLoader)loader, this.s3StorePlacementService, this.client, this.s3Provider);
    }
}

