/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.s3.io;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import org.springframework.content.commons.io.DeletableResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.util.Assert;

public class S3StoreResource
implements WritableResource,
DeletableResource {
    private AmazonS3 client;
    private Resource delegate;
    private String bucket;

    public S3StoreResource(AmazonS3 client, String bucket, Resource delegate) {
        Assert.notNull((Object)client, (String)"client must be specified");
        Assert.hasText((String)bucket, (String)"bucket must be specified");
        Assert.isInstanceOf(WritableResource.class, (Object)delegate);
        this.client = client;
        this.bucket = bucket;
        this.delegate = delegate;
    }

    public AmazonS3 getClient() {
        return this.client;
    }

    public boolean exists() {
        return this.delegate.exists();
    }

    public boolean isReadable() {
        return this.delegate.isReadable();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public URL getURL() throws IOException {
        return this.delegate.getURL();
    }

    public URI getURI() throws IOException {
        return this.delegate.getURI();
    }

    public File getFile() throws IOException {
        return this.delegate.getFile();
    }

    public long contentLength() throws IOException {
        return this.delegate.contentLength();
    }

    public long lastModified() throws IOException {
        return this.delegate.lastModified();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.delegate.createRelative(relativePath);
    }

    public String getFilename() {
        return this.delegate.getFilename();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    public void delete() {
        if (this.delegate.exists()) {
            this.client.deleteObject(new DeleteObjectRequest(this.bucket, this.delegate.getFilename()));
        }
    }

    public boolean isWritable() {
        return ((WritableResource)this.delegate).isWritable();
    }

    public OutputStream getOutputStream() throws IOException {
        return ((WritableResource)this.delegate).getOutputStream();
    }
}

