/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.solr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.springframework.content.commons.repository.StoreAccessException;
import org.springframework.content.commons.search.Searchable;
import org.springframework.content.solr.SolrProperties;
import org.springframework.util.Assert;

public class SolrSearchService
implements Searchable<Object> {
    private static final String field = "id";
    private SolrClient solr;
    private SolrProperties solrProperties;
    private Class<?> domainClass;

    public SolrSearchService(SolrClient solr, SolrProperties solrProperties, Class<?> domainClass) {
        this.solr = solr;
        this.solrProperties = solrProperties;
        this.domainClass = domainClass;
    }

    public List<Object> findKeyword(String queryStr) {
        return this.getIds(this.executeQuery(this.getDomainClass(), queryStr));
    }

    public List<Object> findAllKeywords(String ... terms) {
        String queryStr = this.parseTerms("AND", terms);
        return this.getIds(this.executeQuery(this.getDomainClass(), queryStr));
    }

    public List<Object> findAnyKeywords(String ... terms) {
        String queryStr = this.parseTerms("OR", terms);
        return this.getIds(this.executeQuery(this.getDomainClass(), queryStr));
    }

    public List<Object> findKeywordsNear(int proximity, String ... terms) {
        String termStr = this.parseTerms("NONE", terms);
        String queryStr = "\"" + termStr + "\"~" + Integer.toString(proximity);
        return this.getIds(this.executeQuery(this.getDomainClass(), queryStr));
    }

    public List<Object> findKeywordStartsWith(String term) {
        String queryStr = term + "*";
        return this.getIds(this.executeQuery(this.getDomainClass(), queryStr));
    }

    public List<Object> findKeywordStartsWithAndEndsWith(String a, String b) {
        String queryStr = a + "*" + b;
        return this.getIds(this.executeQuery(this.getDomainClass(), queryStr));
    }

    public List<Object> findAllKeywordsWithWeights(String[] terms, double[] weights) {
        String queryStr = this.parseTermsAndWeights("AND", terms, weights);
        return this.getIds(this.executeQuery(this.getDomainClass(), queryStr));
    }

    String parseTermsAndWeights(String operator, String[] terms, double[] weights) {
        Assert.state((terms.length == weights.length ? 1 : 0) != 0, (String)"all terms must have a weight");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < terms.length - 1; ++i) {
            builder.append("(");
            builder.append(terms[i]);
            builder.append(")^");
            builder.append(weights[i]);
            builder.append(" " + operator + " ");
        }
        builder.append("(");
        builder.append(terms[terms.length - 1]);
        builder.append(")^");
        builder.append(weights[weights.length - 1]);
        return builder.toString();
    }

    String parseTerms(String operator, String ... terms) {
        String separator = operator == "NONE" ? " " : " " + operator + " ";
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < terms.length - 1; ++i) {
            builder.append(terms[i]);
            builder.append(separator);
        }
        builder.append(terms[terms.length - 1]);
        return builder.toString();
    }

    List<Object> getIds(NamedList response) {
        ArrayList<Object> ids = new ArrayList<Object>();
        SolrDocumentList list = (SolrDocumentList)response.get("response");
        for (int j = 0; j < list.size(); ++j) {
            String id = ((SolrDocument)list.get(j)).getFieldValue(field).toString();
            id = id.substring(id.indexOf(58) + 1, id.length());
            ids.add(id);
        }
        return ids;
    }

    QueryRequest solrAuthenticate(QueryRequest request) {
        request.setBasicAuthCredentials(this.solrProperties.getUser(), this.solrProperties.getPassword());
        return request;
    }

    NamedList<Object> executeQuery(Class<?> domainClass, String queryString) {
        SolrQuery query = new SolrQuery();
        query.setQuery("(" + queryString + ") AND id:" + domainClass.getCanonicalName() + "\\:*");
        query.setFields(new String[]{field});
        QueryRequest request = new QueryRequest((SolrParams)query);
        if (this.solrProperties.getUser() != null) {
            request = this.solrAuthenticate(request);
        }
        NamedList response = null;
        try {
            response = this.solr.request((SolrRequest)request, null);
        }
        catch (SolrServerException e) {
            throw new StoreAccessException(String.format("Error running query %s on field %s against solr.", queryString, field), (Throwable)e);
        }
        catch (IOException e) {
            throw new StoreAccessException(String.format("Error running query %s on field %s against solr.", queryString, field), (Throwable)e);
        }
        return response;
    }

    protected Class<?> getDomainClass() {
        return this.domainClass;
    }
}

