/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.solr;

import java.io.IOException;
import java.io.InputStream;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.annotations.HandleAfterSetContent;
import org.springframework.content.commons.annotations.HandleBeforeUnsetContent;
import org.springframework.content.commons.annotations.StoreEventHandler;
import org.springframework.content.commons.repository.StoreAccessException;
import org.springframework.content.commons.repository.events.AfterSetContentEvent;
import org.springframework.content.commons.repository.events.BeforeUnsetContentEvent;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.solr.SolrProperties;
import org.springframework.core.annotation.Order;
import org.springframework.util.Assert;

@StoreEventHandler
public class SolrIndexer {
    private SolrClient solrClient;
    private SolrProperties properties;

    @Autowired
    public SolrIndexer(SolrClient solrClient, SolrProperties properties) {
        Assert.notNull((Object)solrClient, (String)"solrClient must not be null");
        Assert.notNull((Object)properties, (String)"properties must not be null");
        this.solrClient = solrClient;
        this.properties = properties;
    }

    @HandleAfterSetContent
    @Order(value=100)
    protected void onAfterSetContent(AfterSetContentEvent event) {
        Object contentEntity = event.getSource();
        if (!BeanUtils.hasFieldWithAnnotation((Object)contentEntity, ContentId.class)) {
            return;
        }
        if (BeanUtils.getFieldWithAnnotation((Object)contentEntity, ContentId.class) == null) {
            return;
        }
        ContentStreamUpdateRequest up = new ContentStreamUpdateRequest("/update/extract");
        if (this.properties.getUser() != null) {
            up.setBasicAuthCredentials(this.properties.getUser(), this.properties.getPassword());
        }
        up.addContentStream((ContentStream)new ContentEntityStream(event.getStore().getContent(contentEntity)));
        String id = BeanUtils.getFieldWithAnnotation((Object)contentEntity, ContentId.class).toString();
        up.setParam("literal.id", contentEntity.getClass().getCanonicalName() + ":" + id);
        up.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
        try {
            this.solrClient.request((SolrRequest)up, null);
        }
        catch (SolrServerException e) {
            throw new StoreAccessException(String.format("Error updating entry in solr index %s", id), (Throwable)e);
        }
        catch (IOException e) {
            throw new StoreAccessException(String.format("Error updating entry in solr index %s", id), (Throwable)e);
        }
    }

    @HandleBeforeUnsetContent
    @Order(value=100)
    protected void onBeforeUnsetContent(BeforeUnsetContentEvent event) {
        Object contentEntity = event.getSource();
        if (!BeanUtils.hasFieldWithAnnotation((Object)contentEntity, ContentId.class)) {
            return;
        }
        Object id = BeanUtils.getFieldWithAnnotation((Object)contentEntity, ContentId.class);
        if (id == null) {
            return;
        }
        UpdateRequest up = new UpdateRequest();
        up.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
        up.deleteById(contentEntity.getClass().getCanonicalName() + ":" + id.toString());
        if (this.properties.getUser() != null) {
            up.setBasicAuthCredentials(this.properties.getUser(), this.properties.getPassword());
        }
        try {
            this.solrClient.request((SolrRequest)up, null);
        }
        catch (SolrServerException e) {
            throw new StoreAccessException(String.format("Error deleting entry from solr index %s", id.toString()), (Throwable)e);
        }
        catch (IOException e) {
            throw new StoreAccessException(String.format("Error deleting entry from solr index %s", id.toString()), (Throwable)e);
        }
    }

    public class ContentEntityStream
    extends ContentStreamBase {
        private InputStream stream;

        public ContentEntityStream(InputStream stream) {
            this.stream = stream;
        }

        public InputStream getStream() throws IOException {
            return this.stream;
        }
    }
}

