/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.solr;

import internal.org.springframework.content.solr.SolrSearchService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.solr.client.solrj.SolrClient;
import org.springframework.content.commons.repository.StoreExtension;
import org.springframework.content.commons.repository.StoreInvoker;
import org.springframework.content.commons.search.Searchable;
import org.springframework.content.commons.utils.ReflectionService;
import org.springframework.content.solr.SolrProperties;
import org.springframework.core.convert.ConversionService;

public class SolrSearchContentRepositoryExtension
implements StoreExtension {
    private SolrClient solr;
    private ReflectionService reflectionService;
    private ConversionService conversionService;
    private SolrProperties solrProperties;

    public SolrSearchContentRepositoryExtension(SolrClient solr, ReflectionService reflectionService, ConversionService conversionService, SolrProperties solrProperties) {
        this.solr = solr;
        this.reflectionService = reflectionService;
        this.conversionService = conversionService;
        this.solrProperties = solrProperties;
    }

    public Set<Method> getMethods() {
        HashSet<Method> methods = new HashSet<Method>();
        methods.addAll(Arrays.asList(Searchable.class.getMethods()));
        return methods;
    }

    public Object invoke(MethodInvocation invocation, StoreInvoker invoker) {
        ArrayList<Object> newList = new ArrayList<Object>();
        Class clazz = invoker.getContentIdClass();
        Class domainClass = invoker.getDomainClass();
        SolrSearchService tgt = new SolrSearchService(this.solr, this.solrProperties, domainClass);
        List list = (List)this.reflectionService.invokeMethod(invocation.getMethod(), (Object)tgt, invocation.getArguments());
        for (String item : list) {
            if (!this.conversionService.canConvert(item.getClass(), clazz)) {
                throw new IllegalStateException(String.format("Cannot convert item of type %s to %s", item.getClass().getName(), clazz.getName()));
            }
            newList.add(this.conversionService.convert((Object)item, clazz));
        }
        return newList;
    }
}

