/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.versions.interceptors;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Version;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class OptimisticLockingInterceptor
implements MethodInterceptor {
    private static Method getContentMethod = ReflectionUtils.findMethod(ContentStore.class, (String)"getContent", (Class[])new Class[]{Object.class});
    private static Method setContentMethod;
    private static Method unsetContentMethod;
    private final EntityManager em;

    public OptimisticLockingInterceptor(EntityManager em) {
        this.em = em;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object rc = null;
        if (getContentMethod.equals(methodInvocation.getMethod())) {
            if (methodInvocation.getArguments().length > 0) {
                Object entity = methodInvocation.getArguments()[0];
                entity = this.lock(entity);
                ((ProxyMethodInvocation)methodInvocation).setArguments(new Object[]{entity});
                rc = methodInvocation.proceed();
            }
        } else if (setContentMethod.equals(methodInvocation.getMethod())) {
            if (methodInvocation.getArguments().length > 0) {
                Object entity = methodInvocation.getArguments()[0];
                entity = this.lock(entity);
                ((ProxyMethodInvocation)methodInvocation).setArguments(new Object[]{entity, methodInvocation.getArguments()[1]});
                methodInvocation.proceed();
                this.touch(entity, Version.class);
            }
        } else if (unsetContentMethod.equals(methodInvocation.getMethod())) {
            if (methodInvocation.getArguments().length > 0) {
                Object entity = methodInvocation.getArguments()[0];
                entity = this.lock(entity);
                ((ProxyMethodInvocation)methodInvocation).setArguments(new Object[]{entity});
                methodInvocation.proceed();
                this.touch(entity, Version.class);
            }
        } else {
            rc = methodInvocation.proceed();
        }
        return rc;
    }

    protected Object lock(Object entity) {
        if (this.em == null) {
            return entity;
        }
        if (!BeanUtils.hasFieldWithAnnotation((Object)entity, Version.class)) {
            return entity;
        }
        entity = this.em.merge(entity);
        this.em.lock(entity, LockModeType.OPTIMISTIC);
        return entity;
    }

    private void touch(Object domainObj, Class<? extends Annotation> annotation) {
        Field f = BeanUtils.findFieldWithAnnotation((Object)domainObj, annotation);
        if (f == null) {
            return;
        }
        Object version = BeanUtils.getFieldWithAnnotation((Object)domainObj, annotation);
        if (f.getType().isAssignableFrom(Integer.class)) {
            version = Math.incrementExact((Integer)version);
        } else if (f.getType().isAssignableFrom(Long.class)) {
            version = Math.incrementExact((Long)version);
        }
        BeanUtils.setFieldWithAnnotation((Object)domainObj, annotation, (Object)version);
    }

    static {
        Assert.notNull((Object)getContentMethod);
        setContentMethod = ReflectionUtils.findMethod(ContentStore.class, (String)"setContent", (Class[])new Class[]{Object.class, InputStream.class});
        Assert.notNull((Object)setContentMethod);
        unsetContentMethod = ReflectionUtils.findMethod(ContentStore.class, (String)"unsetContent", (Class[])new Class[]{Object.class});
        Assert.notNull((Object)unsetContentMethod);
    }
}

