/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.versions.impl;

import internal.org.springframework.versions.AuthenticationFacade;
import internal.org.springframework.versions.LockingService;
import internal.org.springframework.versions.jpa.CloningService;
import internal.org.springframework.versions.jpa.EntityInformationFacade;
import internal.org.springframework.versions.jpa.VersioningService;
import java.io.Serializable;
import java.security.Principal;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.security.core.Authentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.versions.AncestorId;
import org.springframework.versions.AncestorRootId;
import org.springframework.versions.LockOwner;
import org.springframework.versions.LockOwnerException;
import org.springframework.versions.LockingAndVersioningException;
import org.springframework.versions.LockingAndVersioningRepository;
import org.springframework.versions.SuccessorId;
import org.springframework.versions.VersionInfo;
import org.springframework.versions.VersionNumber;

public class LockingAndVersioningRepositoryImpl<T, ID extends Serializable>
implements LockingAndVersioningRepository<T, ID> {
    private EntityManager em;
    private EntityInformationFacade entityInfo;
    private EntityInformation<T, ?> entityInformation;
    private AuthenticationFacade auth;
    private LockingService lockingService;
    private VersioningService versioner;
    private CloningService cloner;

    @Autowired(required=false)
    public LockingAndVersioningRepositoryImpl() {
    }

    @Autowired(required=false)
    public LockingAndVersioningRepositoryImpl(EntityManager em, EntityInformationFacade entityInfo, AuthenticationFacade auth, LockingService locker, VersioningService versioner, CloningService cloner) {
        this.em = em;
        this.entityInfo = entityInfo;
        this.auth = auth;
        this.lockingService = locker;
        this.versioner = versioner;
        this.cloner = cloner;
    }

    @Transactional
    public <S extends T> S lock(S entity) {
        Authentication authentication = this.auth.getAuthentication();
        if (!authentication.isAuthenticated()) {
            throw new SecurityException("no principal");
        }
        Object id = BeanUtils.getFieldWithAnnotation(entity, javax.persistence.Id.class);
        if (id == null) {
            id = BeanUtils.getFieldWithAnnotation(entity, Id.class);
        }
        if (id == null) {
            throw new IllegalStateException("@Id missing");
        }
        if (this.lockingService.lock(id, (Principal)authentication)) {
            BeanUtils.setFieldWithAnnotation(entity, LockOwner.class, (Object)authentication.getName());
            return this.save(entity);
        }
        throw new IllegalStateException(String.format("failed to lock %s", id));
    }

    @Transactional
    public <S extends T> S unlock(S entity) {
        Authentication authentication = this.auth.getAuthentication();
        if (!authentication.isAuthenticated()) {
            throw new SecurityException("no principal");
        }
        Object id = BeanUtils.getFieldWithAnnotation(entity, javax.persistence.Id.class);
        if (id == null) {
            id = BeanUtils.getFieldWithAnnotation(entity, Id.class);
        }
        if (id == null) {
            throw new IllegalStateException("@Id missing");
        }
        String principal = authentication.getName();
        Principal lockOwner = this.lockingService.lockOwner(id);
        if (lockOwner == null || !principal.equals(lockOwner.getName())) {
            throw new LockOwnerException(String.format("not lock owner: %s has lock owner %s", id, lockOwner != null ? lockOwner.getName() : ""));
        }
        BeanUtils.setFieldWithAnnotation(entity, LockOwner.class, null);
        entity = this.save(entity);
        if (this.lockingService.unlock(id, (Principal)authentication)) {
            return entity;
        }
        throw new IllegalStateException(String.format("failed to unlock %s", id));
    }

    @Transactional
    public <S extends T> S save(S entity) {
        if (this.entityInformation == null) {
            this.entityInformation = this.entityInfo.getEntityInformation(entity.getClass(), this.em);
        }
        if (this.entityInformation.isNew(entity)) {
            BeanUtils.setFieldWithAnnotation(entity, VersionNumber.class, (Object)"1.0");
            this.em.persist(entity);
            return entity;
        }
        Object id = this.getId(entity);
        if (id == null) {
            return null;
        }
        Authentication authentication = this.auth.getAuthentication();
        Principal lockOwner = this.lockingService.lockOwner(id);
        if (authentication == null || !authentication.isAuthenticated() && lockOwner == null) {
            return (S)this.em.merge(entity);
        }
        if (authentication != null && authentication.isAuthenticated() && (lockOwner == null || authentication.getName().equals(lockOwner.getName()))) {
            return (S)this.em.merge(entity);
        }
        throw new LockOwnerException(String.format("entity not locked by you", new Object[0]));
    }

    @Transactional
    public <S extends T> S version(S currentVersion, VersionInfo info) {
        Object ancestorRoot;
        Authentication authentication = this.auth.getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new SecurityException("no principal");
        }
        Object id = this.getId(currentVersion);
        if (id == null) {
            return null;
        }
        if (!this.isHead(currentVersion)) {
            throw new LockingAndVersioningException("not head");
        }
        Principal lockOwner = this.lockingService.lockOwner(id);
        if (lockOwner == null || !authentication.isAuthenticated() || !authentication.getName().equals(lockOwner.getName())) {
            throw new LockOwnerException(String.format("not lock owner", new Object[0]));
        }
        if (this.isAnestralRoot(currentVersion)) {
            ancestorRoot = currentVersion = this.versioner.establishAncestralRoot(currentVersion);
        } else {
            Object ancestorRootId = this.getAncestralRootId(currentVersion);
            ancestorRoot = this.em.find(currentVersion.getClass(), ancestorRootId);
            if (ancestorRoot == null) {
                throw new LockingAndVersioningException(String.format("ancestor root not found: %s", ancestorRootId));
            }
        }
        Object newVersion = this.cloner.clone(currentVersion);
        this.unlock(currentVersion);
        newVersion = this.versioner.establishSuccessor(newVersion, info.getNumber(), info.getLabel(), ancestorRoot, currentVersion);
        this.em.persist(newVersion);
        Object newId = this.getId(newVersion);
        currentVersion = this.versioner.establishAncestor(currentVersion, newVersion);
        this.em.merge(currentVersion);
        newVersion = this.lock(newVersion);
        this.em.merge(newVersion);
        return (S)newVersion;
    }

    public <S extends T> List<S> findAllVersionsLatest() {
        return null;
    }

    public <S extends T> List<S> findAllVersions(S entity) {
        return null;
    }

    public <S extends T> void delete(S entity) {
        Authentication authentication = this.auth.getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new SecurityException("no principal");
        }
        Object id = this.getId(entity);
        if (id == null) {
            return;
        }
        if (!this.isHead(entity)) {
            throw new LockingAndVersioningException("not head");
        }
        boolean relock = false;
        if (this.lockingService.lockOwner(id) != null && !this.lockingService.isLockOwner(id, (Principal)authentication)) {
            throw new LockOwnerException("not lock owner");
        }
        if (this.lockingService.lockOwner(id) != null && this.lockingService.isLockOwner(id, (Principal)authentication)) {
            relock = true;
            this.lockingService.unlock(id, (Principal)authentication);
        }
        Object ancestorRootId = this.getAncestralRootId(entity);
        Object ancestorId = this.getAncestorId(entity);
        Object ancestor = null;
        if (ancestorId == null) {
            ancestorId = ancestorRootId;
        }
        if (ancestorId != null) {
            ancestor = this.em.find(entity.getClass(), ancestorId);
            BeanUtils.setFieldWithAnnotation((Object)ancestor, SuccessorId.class, null);
            this.lockingService.lock(ancestorId, (Principal)authentication);
        }
        this.em.remove(entity);
    }

    protected <S extends T> boolean isHead(S entity) {
        boolean isHead = false;
        if (BeanUtils.hasFieldWithAnnotation(entity, SuccessorId.class)) {
            return BeanUtils.getFieldWithAnnotation(entity, SuccessorId.class) == null;
        }
        return isHead;
    }

    protected <S extends T> boolean isAnestralRoot(S entity) {
        boolean isAncestralRoot = false;
        if (BeanUtils.hasFieldWithAnnotation(entity, AncestorRootId.class)) {
            return BeanUtils.getFieldWithAnnotation(entity, AncestorRootId.class) == null;
        }
        return isAncestralRoot;
    }

    protected <S extends T> Object getAncestralRootId(S entity) {
        return BeanUtils.getFieldWithAnnotation(entity, AncestorRootId.class);
    }

    protected <S extends T> Object getAncestorId(S entity) {
        return BeanUtils.getFieldWithAnnotation(entity, AncestorId.class);
    }

    protected <S extends T> Object getId(S entity) {
        Object id = BeanUtils.getFieldWithAnnotation(entity, javax.persistence.Id.class);
        if (id == null) {
            id = BeanUtils.getFieldWithAnnotation(entity, Id.class);
        }
        if (id == null) {
            return null;
        }
        return id;
    }
}

