/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.versions.jpa;

import internal.org.springframework.versions.jpa.CloningService;
import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ClassUtils;
import org.springframework.versions.LockingAndVersioningException;

public class JpaCloningServiceImpl
implements CloningService {
    private static Log logger = LogFactory.getLog(JpaCloningServiceImpl.class);

    @Override
    public Object clone(Object entity) {
        Class<?> clazz = entity.getClass();
        Constructor copyCtor = ClassUtils.getConstructorIfAvailable(clazz, (Class[])new Class[]{clazz});
        if (copyCtor == null) {
            throw new LockingAndVersioningException(String.format("no copy constructor: %s", clazz.getCanonicalName()));
        }
        Object newInstance = null;
        try {
            newInstance = copyCtor.newInstance(entity);
        }
        catch (Exception e) {
            throw new LockingAndVersioningException("copy constructor failed", (Throwable)e);
        }
        return newInstance;
    }
}

