/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.versions.impl;

import internal.org.springframework.versions.AuthenticationFacade;
import internal.org.springframework.versions.LockingService;
import internal.org.springframework.versions.jpa.CloningService;
import internal.org.springframework.versions.jpa.EntityInformationFacade;
import internal.org.springframework.versions.jpa.JpaCloningServiceImpl;
import internal.org.springframework.versions.jpa.VersioningService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.security.core.Authentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.versions.AncestorId;
import org.springframework.versions.AncestorRootId;
import org.springframework.versions.LockOwner;
import org.springframework.versions.LockOwnerException;
import org.springframework.versions.LockingAndVersioningException;
import org.springframework.versions.LockingAndVersioningRepository;
import org.springframework.versions.SuccessorId;
import org.springframework.versions.VersionInfo;
import org.springframework.versions.VersionLabel;
import org.springframework.versions.VersionNumber;

public class LockingAndVersioningRepositoryImpl<T, ID extends Serializable>
implements LockingAndVersioningRepository<T, ID> {
    private static Log logger = LogFactory.getLog(JpaCloningServiceImpl.class);
    private EntityManager em;
    private EntityInformationFacade entityInfo;
    private EntityInformation<T, ?> entityInformation;
    private AuthenticationFacade auth;
    private LockingService lockingService;
    private VersioningService versioner;
    private CloningService cloner;

    @Autowired(required=false)
    public LockingAndVersioningRepositoryImpl() {
    }

    @Autowired(required=false)
    public LockingAndVersioningRepositoryImpl(EntityManager em, EntityInformationFacade entityInfo, AuthenticationFacade auth, LockingService locker, VersioningService versioner, CloningService cloner) {
        this.em = em;
        this.entityInfo = entityInfo;
        this.auth = auth;
        this.lockingService = locker;
        this.versioner = versioner;
        this.cloner = cloner;
    }

    @Transactional
    public <S extends T> S lock(S entity) {
        Authentication authentication = this.auth.getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new SecurityException("no principal");
        }
        Object id = BeanUtils.getFieldWithAnnotation(entity, javax.persistence.Id.class);
        if (id == null) {
            id = BeanUtils.getFieldWithAnnotation(entity, Id.class);
        }
        if (id == null) {
            throw new IllegalStateException("@Id missing");
        }
        String principal = authentication.getName();
        Principal lockOwner = this.lockingService.lockOwner(id);
        if (lockOwner != null && !principal.equals(lockOwner.getName())) {
            throw new LockOwnerException(String.format("not lock owner: %s has lock owner '%s'", id, lockOwner != null ? lockOwner.getName() : ""));
        }
        if (this.lockingService.lock(id, (Principal)authentication)) {
            BeanUtils.setFieldWithAnnotation(entity, LockOwner.class, (Object)authentication.getName());
            return entity;
        }
        throw new LockingAndVersioningException(String.format("failed to lock %s", id));
    }

    @Transactional
    public <S extends T> S unlock(S entity) {
        Authentication authentication = this.auth.getAuthentication();
        if (!authentication.isAuthenticated()) {
            throw new SecurityException("no principal");
        }
        Object id = BeanUtils.getFieldWithAnnotation(entity, javax.persistence.Id.class);
        if (id == null) {
            id = BeanUtils.getFieldWithAnnotation(entity, Id.class);
        }
        if (id == null) {
            throw new IllegalStateException("@Id missing");
        }
        String principal = authentication.getName();
        Principal lockOwner = this.lockingService.lockOwner(id);
        if (lockOwner == null || !principal.equals(lockOwner.getName())) {
            throw new LockOwnerException(String.format("not lock owner: %s has lock owner '%s'", id, lockOwner != null ? lockOwner.getName() : ""));
        }
        BeanUtils.setFieldWithAnnotation(entity, LockOwner.class, null);
        if (this.lockingService.unlock(id, (Principal)authentication)) {
            return entity;
        }
        throw new LockingAndVersioningException(String.format("failed to unlock %s", id));
    }

    @Transactional
    public <S extends T> S save(S entity) {
        if (this.entityInformation == null) {
            this.entityInformation = this.entityInfo.getEntityInformation(entity.getClass(), this.em);
        }
        if (this.entityInformation.isNew(entity)) {
            BeanUtils.setFieldWithAnnotation(entity, VersionNumber.class, (Object)"1.0");
            this.em.persist(entity);
            return entity;
        }
        Object id = this.getId(entity);
        if (id == null) {
            return null;
        }
        Authentication authentication = this.auth.getAuthentication();
        Principal lockOwner = this.lockingService.lockOwner(id);
        if (authentication == null || !authentication.isAuthenticated() && lockOwner == null) {
            return (S)this.em.merge(entity);
        }
        if (authentication != null && authentication.isAuthenticated() && (lockOwner == null || authentication.getName().equals(lockOwner.getName()))) {
            return (S)this.em.merge(entity);
        }
        throw new LockOwnerException(String.format("entity not locked by you. lock owner: %s", lockOwner.getName()));
    }

    @Transactional
    public <S extends T> S workingCopy(S currentVersion) {
        Object ancestorRoot;
        Authentication authentication = this.auth.getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new SecurityException("no principal");
        }
        Object id = this.getId(currentVersion);
        if (id == null) {
            throw new IllegalStateException("not saved");
        }
        if (!this.isHead(currentVersion)) {
            throw new LockingAndVersioningException("not head");
        }
        Principal lockOwner = this.lockingService.lockOwner(id);
        if (lockOwner == null || !authentication.isAuthenticated() || !authentication.getName().equals(lockOwner.getName())) {
            throw new LockOwnerException(String.format("not lock owner", new Object[0]));
        }
        if (this.isAnestralRoot(currentVersion)) {
            currentVersion = this.versioner.establishAncestralRoot(currentVersion);
            this.em.merge(currentVersion);
            ancestorRoot = currentVersion;
        } else {
            Object ancestorRootId = this.getAncestralRootId(currentVersion);
            ancestorRoot = this.em.find(currentVersion.getClass(), ancestorRootId);
            if (ancestorRoot == null) {
                throw new LockingAndVersioningException(String.format("ancestor root not found: %s", ancestorRootId));
            }
        }
        Object newVersion = this.cloner.clone(currentVersion);
        Object versionNumber = BeanUtils.getFieldWithAnnotation((Object)currentVersion, VersionNumber.class);
        if (versionNumber == null) {
            versionNumber = "";
        }
        newVersion = this.versioner.establishSuccessor(newVersion, versionNumber.toString(), "~~PWC~~", ancestorRoot, currentVersion);
        this.em.persist(newVersion);
        Object newId = this.getId(newVersion);
        newVersion = this.lock(newVersion);
        newVersion = this.em.merge(newVersion);
        return (S)newVersion;
    }

    @Transactional
    public <S extends T> S version(S currentVersion, VersionInfo info) {
        Authentication authentication = this.auth.getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new SecurityException("no principal");
        }
        Object id = this.getId(currentVersion);
        if (id == null) {
            return null;
        }
        if (!this.isHead(currentVersion)) {
            throw new LockingAndVersioningException("not head");
        }
        Principal lockOwner = this.lockingService.lockOwner(id);
        if (lockOwner == null || !authentication.isAuthenticated() || !authentication.getName().equals(lockOwner.getName())) {
            throw new LockOwnerException("not lock owner");
        }
        Object newVersion = null;
        if (!this.isPrivateWorkingCopy(currentVersion)) {
            Object ancestorRoot;
            if (this.isAnestralRoot(currentVersion)) {
                ancestorRoot = currentVersion = this.versioner.establishAncestralRoot(currentVersion);
            } else {
                Object ancestorRootId = this.getAncestralRootId(currentVersion);
                ancestorRoot = this.em.find(currentVersion.getClass(), ancestorRootId);
                if (ancestorRoot == null) {
                    throw new LockingAndVersioningException(String.format("ancestor root not found: %s", ancestorRootId));
                }
            }
            newVersion = this.cloner.clone(currentVersion);
            this.unlock(currentVersion);
            newVersion = this.versioner.establishSuccessor(newVersion, info.getNumber(), info.getLabel(), ancestorRoot, currentVersion);
            this.em.persist(newVersion);
            Object newId = this.getId(newVersion);
            newVersion = this.lock(newVersion);
            newVersion = this.em.merge(newVersion);
        } else {
            newVersion = currentVersion;
            BeanUtils.setFieldWithAnnotation(newVersion, VersionNumber.class, (Object)info.getNumber());
            BeanUtils.setFieldWithAnnotation(newVersion, VersionLabel.class, (Object)info.getLabel());
            newVersion = this.em.merge(newVersion);
            currentVersion = this.em.find(newVersion.getClass(), BeanUtils.getFieldWithAnnotation((Object)newVersion, AncestorId.class));
            this.unlock(currentVersion);
        }
        currentVersion = this.versioner.establishAncestor(currentVersion, newVersion);
        this.em.merge(currentVersion);
        return (S)newVersion;
    }

    public <S extends T> List<S> findAllVersionsLatest() {
        Class clz = this.entityInformation.getJavaType();
        if (this.entityInformation == null) {
            logger.warn((Object)"Unknown entity context.  Try findAllVersionsLatest(Class<S> entityClass)");
            return new ArrayList();
        }
        String sql = "select t from ${entityClass} t where t.${successorId} = null and t.${id} NOT IN (select f1.${id} FROM ${entityClass} f1 inner join ${entityClass} f2 on f1.${ancestorId} = f2.${id} and f2.${successorId} = null)";
        StringSubstitutor sub = new StringSubstitutor(this.getAttributeMap(clz));
        sql = sub.replace(sql);
        TypedQuery q = this.em.createQuery(sql, clz);
        try {
            return q.getResultList();
        }
        catch (NoResultException nre) {
            return new ArrayList();
        }
    }

    public <S extends T> List<S> findAllVersionsLatest(Class<S> entityClass) {
        String sql = "select t from ${entityClass} t where t.${successorId} = null and t.${id} NOT IN (select f1.${id} FROM ${entityClass} f1 inner join ${entityClass} f2 on f1.${ancestorId} = f2.${id} and f2.${successorId} = null)";
        StringSubstitutor sub = new StringSubstitutor(this.getAttributeMap(entityClass));
        sql = sub.replace(sql);
        TypedQuery q = this.em.createQuery(sql, entityClass);
        try {
            return q.getResultList();
        }
        catch (NoResultException nre) {
            return new ArrayList();
        }
    }

    public <S extends T> List<S> findAllVersions(S entity) {
        return this.findAllVersions(entity, Sort.unsorted());
    }

    public <S extends T> List<S> findAllVersions(S entity, Sort sort) {
        StringBuilder builder = new StringBuilder();
        if (sort.isSorted()) {
            builder.append("order by ");
            int i = 0;
            sort.forEach(property -> {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append("t.");
                builder.append(property.getProperty());
                builder.append(" ");
                builder.append(property.getDirection());
            });
        }
        String sql = "select t from ${entityClass} t where t.${ancestorRootId} = " + this.getAncestralRootId(entity);
        if (StringUtils.hasText((CharSequence)builder)) {
            sql = sql + " " + builder.toString();
        }
        StringSubstitutor sub = new StringSubstitutor(this.getAttributeMap(entity.getClass()));
        sql = sub.replace(sql);
        TypedQuery q = this.em.createQuery(sql, entity.getClass());
        try {
            return q.getResultList();
        }
        catch (NoResultException nre) {
            return new ArrayList();
        }
    }

    public void delete(T entity) {
        Authentication authentication = this.auth.getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new SecurityException("no principal");
        }
        Object id = this.getId(entity);
        if (id == null) {
            return;
        }
        if (!this.isHead(entity)) {
            throw new LockingAndVersioningException("not head");
        }
        boolean relock = false;
        if (this.lockingService.lockOwner(id) != null && !this.lockingService.isLockOwner(id, (Principal)authentication)) {
            throw new LockOwnerException("not lock owner");
        }
        if (this.lockingService.lockOwner(id) != null && this.lockingService.isLockOwner(id, (Principal)authentication)) {
            relock = true;
        }
        Object ancestorRootId = this.getAncestralRootId(entity);
        Object ancestorId = this.getAncestorId(entity);
        Object ancestor = null;
        if (ancestorId == null) {
            ancestorId = ancestorRootId;
        }
        if (ancestorId != null) {
            ancestor = this.em.find(entity.getClass(), ancestorId);
            Principal lockOwner = null;
            lockOwner = this.lockingService.lockOwner(ancestorId);
            if (lockOwner != null && !Objects.equals(authentication.getName(), lockOwner.getName())) {
                throw new LockOwnerException(String.format("Not lock owner %s", ancestorId));
            }
            if (lockOwner == null && relock) {
                this.lockingService.lock(ancestorId, (Principal)authentication);
            }
            BeanUtils.setFieldWithAnnotation((Object)ancestor, SuccessorId.class, null);
            if (ancestorRootId.equals(ancestorId)) {
                BeanUtils.setFieldWithAnnotation((Object)ancestor, AncestorRootId.class, null);
            }
        }
        this.lockingService.unlock(id, (Principal)authentication);
        this.em.remove(this.em.contains(entity) ? entity : this.em.merge(entity));
    }

    @Transactional
    public void deleteAllVersions(T entity) {
        Authentication authentication = this.auth.getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new SecurityException("no principal");
        }
        Object id = this.getId(entity);
        if (id == null) {
            return;
        }
        if (!this.isHead(entity)) {
            throw new LockingAndVersioningException("not head");
        }
        if (this.lockingService.lockOwner(id) != null && !this.lockingService.isLockOwner(id, (Principal)authentication)) {
            throw new LockOwnerException("not lock owner");
        }
        String sql = "delete from ${entityClass} t where t.${ancestorRootId} = " + this.getAncestralRootId(entity);
        StringSubstitutor sub = new StringSubstitutor(this.getAttributeMap(entity.getClass()));
        sql = sub.replace(sql);
        Query q = this.em.createQuery(sql);
        q.executeUpdate();
    }

    protected <T> boolean isHead(T entity) {
        boolean isHead = false;
        if (BeanUtils.hasFieldWithAnnotation(entity, SuccessorId.class)) {
            return BeanUtils.getFieldWithAnnotation(entity, SuccessorId.class) == null;
        }
        return isHead;
    }

    protected <S extends T> boolean isAnestralRoot(S entity) {
        boolean isAncestralRoot = false;
        if (BeanUtils.hasFieldWithAnnotation(entity, AncestorRootId.class)) {
            return BeanUtils.getFieldWithAnnotation(entity, AncestorRootId.class) == null;
        }
        return isAncestralRoot;
    }

    public <S extends T> boolean isPrivateWorkingCopy(S entity) {
        String sql = "select count(f1.${id}) FROM ${entityClass} f1 inner join ${entityClass} f2 on f1.${ancestorId} = f2.${id} and f2.${successorId} IS NULL where f1.${id} = :id";
        Map<String, String> attributes = this.getAttributeMap(entity.getClass());
        StringSubstitutor sub = new StringSubstitutor(attributes);
        sql = sub.replace(sql);
        TypedQuery q = this.em.createQuery(sql, Long.class);
        q.setParameter("id", BeanUtils.getFieldWithAnnotation(entity, javax.persistence.Id.class));
        return (Long)q.getSingleResult() == 1L;
    }

    public <S extends T> S findWorkingCopy(S entity) {
        String sql = "select f1 FROM ${entityClass} f1 inner join ${entityClass} f2 on f1.${ancestorId} = f2.${id} and f2.${successorId} IS NULL where f1.${ancestorRootId} = :id";
        Map<String, String> attributes = this.getAttributeMap(entity.getClass());
        StringSubstitutor sub = new StringSubstitutor(attributes);
        sql = sub.replace(sql);
        TypedQuery q = this.em.createQuery(sql, entity.getClass());
        q.setParameter("id", this.getAncestralRootId(entity));
        try {
            return (S)q.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    private Map<String, String> getAttributeMap(Class<?> entityClass) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("id", this.idAttribute(entityClass));
        attributes.put("ancestorId", this.ancestorIdAttribute(entityClass));
        attributes.put("ancestorRootId", this.ancestorRootIdAttribute(entityClass));
        attributes.put("successorId", this.successorIdAttribute(entityClass));
        attributes.put("entityClass", entityClass.getName());
        return attributes;
    }

    private <S extends T> String idAttribute(Class<?> entityClass) {
        Field idField = BeanUtils.findFieldWithAnnotation(entityClass, javax.persistence.Id.class);
        if (idField == null) {
            idField = BeanUtils.findFieldWithAnnotation(entityClass, Id.class);
        }
        if (idField == null) {
            throw new IllegalStateException(String.format("Entity class is missing @Id field: %s", entityClass.getCanonicalName()));
        }
        return idField.getName();
    }

    private String successorIdAttribute(Class<?> entityClass) {
        Field successorIdField = BeanUtils.findFieldWithAnnotation(entityClass, SuccessorId.class);
        if (successorIdField == null) {
            throw new IllegalStateException(String.format("Entity class is missing @SuccessorId field: %s", entityClass.getCanonicalName()));
        }
        return successorIdField.getName();
    }

    private String ancestorIdAttribute(Class<?> entityClass) {
        Field ancestorIdField = BeanUtils.findFieldWithAnnotation(entityClass, AncestorId.class);
        if (ancestorIdField == null) {
            throw new IllegalStateException(String.format("Entity class is missing @AncestorId field: %s", entityClass.getCanonicalName()));
        }
        return ancestorIdField.getName();
    }

    private String ancestorRootIdAttribute(Class<?> entityClass) {
        Field ancestorRootIdField = BeanUtils.findFieldWithAnnotation(entityClass, AncestorRootId.class);
        if (ancestorRootIdField == null) {
            throw new IllegalStateException(String.format("Entity class is missing @AncestorRootId field: %s", entityClass.getCanonicalName()));
        }
        return ancestorRootIdField.getName();
    }

    protected <T> Object getAncestralRootId(T entity) {
        return BeanUtils.getFieldWithAnnotation(entity, AncestorRootId.class);
    }

    protected <T> Object getAncestorId(T entity) {
        return BeanUtils.getFieldWithAnnotation(entity, AncestorId.class);
    }

    protected <T> Object getId(T entity) {
        Object id = BeanUtils.getFieldWithAnnotation(entity, javax.persistence.Id.class);
        if (id == null) {
            id = BeanUtils.getFieldWithAnnotation(entity, Id.class);
        }
        if (id == null) {
            return null;
        }
        return id;
    }
}

