/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.versions.jpa;

import internal.org.springframework.versions.AuthenticationFacade;
import internal.org.springframework.versions.LockingService;
import jakarta.persistence.EntityManager;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;
import org.springframework.versions.LockingAndVersioningProxyFactory;
import org.springframework.versions.interceptors.OptimisticLockingInterceptor;
import org.springframework.versions.interceptors.PessimisticLockingInterceptor;

public class JpaLockingAndVersioningProxyFactoryImpl
implements LockingAndVersioningProxyFactory {
    private BeanFactory beanFactory;
    private PlatformTransactionManager ptm;
    private EntityManager em;
    private LockingService locker;
    private AuthenticationFacade auth;

    public JpaLockingAndVersioningProxyFactoryImpl(BeanFactory beanFactory, PlatformTransactionManager ptm, EntityManager em, LockingService locker, AuthenticationFacade auth) {
        this.beanFactory = beanFactory;
        this.ptm = ptm;
        this.em = em;
        this.locker = locker;
        this.auth = auth;
    }

    public void apply(ProxyFactory proxy) {
        Assert.notNull((Object)this.beanFactory, (String)"Locking and Versioning requires a BeanFactory");
        Assert.notNull((Object)this.ptm, (String)"Locking and Versioning requires a PlatformTransactionManager");
        Assert.notNull((Object)this.em, (String)"Locking and Versioning requires an EntityManager");
        Assert.notNull((Object)this.locker, (String)"Locking and Versioning requires a locking service");
        Assert.notNull((Object)this.auth, (String)"Locking and Versioning requires an authentication service");
        this.addTransactionAdviceIfNeeded(proxy, this.ptm);
        proxy.addAdvice((Advice)new OptimisticLockingInterceptor(this.em));
        proxy.addAdvice((Advice)new PessimisticLockingInterceptor(this.locker, this.auth));
    }

    protected void addTransactionAdviceIfNeeded(ProxyFactory proxy, PlatformTransactionManager ptm) {
        Advisor[] advisors;
        for (Advisor advisor : advisors = proxy.getAdvisors()) {
            if (!(advisor.getAdvice() instanceof TransactionInterceptor)) continue;
            return;
        }
        proxy.addAdvice(this.transactionInterceptor(ptm));
    }

    protected Advice transactionInterceptor(PlatformTransactionManager ptm) {
        TransactionInterceptor transactionInterceptor = new TransactionInterceptor(this.ptm, (TransactionAttributeSource)new AnnotationTransactionAttributeSource());
        transactionInterceptor.setBeanFactory(this.beanFactory);
        transactionInterceptor.afterPropertiesSet();
        return transactionInterceptor;
    }
}

