/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.versions.jpa;

import internal.org.springframework.versions.jpa.VersioningService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Id;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.versions.AncestorId;
import org.springframework.versions.AncestorRootId;
import org.springframework.versions.SuccessorId;
import org.springframework.versions.VersionLabel;
import org.springframework.versions.VersionNumber;

public class JpaVersioningServiceImpl
implements VersioningService {
    private EntityManager em;

    public JpaVersioningServiceImpl(EntityManager em) {
        this.em = em;
    }

    @Override
    public Object establishAncestralRoot(Object entity) {
        Object id = this.getId(entity);
        if (BeanUtils.hasFieldWithAnnotation((Object)entity, AncestorId.class)) {
            BeanUtils.setFieldWithAnnotation((Object)entity, AncestorId.class, null);
        }
        if (BeanUtils.hasFieldWithAnnotation((Object)entity, AncestorRootId.class) && BeanUtils.getFieldWithAnnotation((Object)entity, AncestorRootId.class) == null) {
            BeanUtils.setFieldWithAnnotation((Object)entity, AncestorRootId.class, (Object)id);
        }
        return entity;
    }

    @Override
    public Object establishAncestor(Object entity, Object successor) {
        if (BeanUtils.hasFieldWithAnnotation((Object)entity, SuccessorId.class)) {
            Object successorId = this.getId(successor);
            BeanUtils.setFieldWithAnnotation((Object)entity, SuccessorId.class, (Object)successorId);
        }
        return entity;
    }

    @Override
    public Object establishSuccessor(Object candidate, String versionNo, String versionLabel, Object ancestralRoot, Object ancestor) {
        BeanUtils.setFieldWithAnnotation((Object)candidate, VersionNumber.class, (Object)versionNo);
        BeanUtils.setFieldWithAnnotation((Object)candidate, VersionLabel.class, (Object)versionLabel);
        if (BeanUtils.hasFieldWithAnnotation((Object)candidate, AncestorRootId.class)) {
            Object ancestralRootId = this.getId(ancestralRoot);
            BeanUtils.setFieldWithAnnotation((Object)candidate, AncestorRootId.class, (Object)ancestralRootId);
        }
        if (BeanUtils.hasFieldWithAnnotation((Object)candidate, AncestorId.class) && ancestor != null) {
            Object ancestorId = this.getId(ancestor);
            BeanUtils.setFieldWithAnnotation((Object)candidate, AncestorId.class, (Object)ancestorId);
        }
        return candidate;
    }

    protected Object getId(Object entity) {
        Object id = BeanUtils.getFieldWithAnnotation((Object)entity, Id.class);
        if (id == null) {
            id = BeanUtils.getFieldWithAnnotation((Object)entity, org.springframework.data.annotation.Id.class);
        }
        if (id == null) {
            return null;
        }
        return id;
    }
}

