/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.versions.interceptors;

import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Version;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class OptimisticLockingInterceptor
implements MethodInterceptor {
    private static Method getContentMethod = ReflectionUtils.findMethod(ContentStore.class, (String)"getContent", (Class[])new Class[]{Object.class});
    private static Method getContentPropertyPathMethod;
    private static Method setContentMethod;
    private static Method setContentPropertyPathMethod;
    private static Method setContentMethodWithResource;
    private static Method setContentMethodWithPropertyPathAndResource;
    private static Method unsetContentMethod;
    private static Method unsetContentPropertyPathMethod;
    private final EntityManager em;

    public OptimisticLockingInterceptor(EntityManager em) {
        this.em = em;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object rc = null;
        if (getContentMethod.equals(methodInvocation.getMethod()) || getContentPropertyPathMethod.equals(methodInvocation.getMethod())) {
            if (methodInvocation.getArguments().length > 0) {
                Object[] args = methodInvocation.getArguments();
                args[0] = this.lock(args[0]);
                ((ProxyMethodInvocation)methodInvocation).setArguments(args);
                rc = methodInvocation.proceed();
            }
        } else if (setContentMethod.equals(methodInvocation.getMethod()) || setContentPropertyPathMethod.equals(methodInvocation.getMethod()) || setContentMethodWithResource.equals(methodInvocation.getMethod()) || setContentMethodWithPropertyPathAndResource.equals(methodInvocation.getMethod()) || unsetContentMethod.equals(methodInvocation.getMethod()) || unsetContentPropertyPathMethod.equals(methodInvocation.getMethod())) {
            if (methodInvocation.getArguments().length > 0) {
                Object[] args = methodInvocation.getArguments();
                args[0] = this.lock(args[0]);
                ((ProxyMethodInvocation)methodInvocation).setArguments(args);
                Object entity = methodInvocation.proceed();
                this.touch(entity, Version.class);
                return entity;
            }
        } else {
            rc = methodInvocation.proceed();
        }
        return rc;
    }

    protected Object lock(Object entity) {
        if (this.em == null) {
            return entity;
        }
        if (!BeanUtils.hasFieldWithAnnotation((Object)entity, Version.class)) {
            return entity;
        }
        entity = this.em.merge(entity);
        this.em.lock(entity, LockModeType.OPTIMISTIC);
        return entity;
    }

    private void touch(Object domainObj, Class<? extends Annotation> annotation) {
        Field f = BeanUtils.findFieldWithAnnotation((Object)domainObj, annotation);
        if (f == null) {
            return;
        }
        Object version = BeanUtils.getFieldWithAnnotation((Object)domainObj, annotation);
        if (f.getType().isAssignableFrom(Integer.class)) {
            version = Math.incrementExact((Integer)version);
        } else if (f.getType().isAssignableFrom(Long.class)) {
            version = Math.incrementExact((Long)version);
        }
        BeanUtils.setFieldWithAnnotation((Object)domainObj, annotation, (Object)version);
    }

    static {
        Assert.notNull((Object)getContentMethod, (String)"Unable to find getContent method");
        getContentPropertyPathMethod = ReflectionUtils.findMethod(ContentStore.class, (String)"getContent", (Class[])new Class[]{Object.class, PropertyPath.class});
        Assert.notNull((Object)getContentPropertyPathMethod, (String)"Unable to find getContent method");
        setContentMethod = ReflectionUtils.findMethod(ContentStore.class, (String)"setContent", (Class[])new Class[]{Object.class, InputStream.class});
        Assert.notNull((Object)setContentMethod, (String)"Unable to find setContent method");
        setContentPropertyPathMethod = ReflectionUtils.findMethod(ContentStore.class, (String)"setContent", (Class[])new Class[]{Object.class, PropertyPath.class, InputStream.class});
        Assert.notNull((Object)setContentPropertyPathMethod, (String)"Unable to find setContent method");
        setContentMethodWithResource = ReflectionUtils.findMethod(ContentStore.class, (String)"setContent", (Class[])new Class[]{Object.class, Resource.class});
        Assert.notNull((Object)setContentMethodWithResource, (String)"Unable to find setContent method");
        setContentMethodWithPropertyPathAndResource = ReflectionUtils.findMethod(ContentStore.class, (String)"setContent", (Class[])new Class[]{Object.class, PropertyPath.class, Resource.class});
        Assert.notNull((Object)setContentMethodWithPropertyPathAndResource, (String)"Unable to find setContent method");
        unsetContentMethod = ReflectionUtils.findMethod(ContentStore.class, (String)"unsetContent", (Class[])new Class[]{Object.class});
        Assert.notNull((Object)unsetContentMethod, (String)"Unable to find unsetContent method");
        unsetContentPropertyPathMethod = ReflectionUtils.findMethod(ContentStore.class, (String)"unsetContent", (Class[])new Class[]{Object.class, PropertyPath.class});
        Assert.notNull((Object)unsetContentPropertyPathMethod, (String)"Unable to find unsetContent method");
    }
}

