/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.versions.interceptors;

import internal.org.springframework.versions.AuthenticationFacade;
import internal.org.springframework.versions.LockingService;
import jakarta.persistence.Id;
import java.lang.reflect.Field;
import java.security.Principal;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.versions.LockOwnerException;
import org.springframework.versions.LockParticipant;

public class PessimisticLockingInterceptor
implements MethodInterceptor {
    private LockingService locker;
    private AuthenticationFacade auth;
    private static final ReflectionUtils.AnnotationFieldFilter ID_FILTER = new ReflectionUtils.AnnotationFieldFilter(Id.class);
    private static final ReflectionUtils.AnnotationFieldFilter DATA_ID_FILTER = new ReflectionUtils.AnnotationFieldFilter(org.springframework.data.annotation.Id.class);

    public PessimisticLockingInterceptor(LockingService locker, AuthenticationFacade auth) {
        Assert.notNull((Object)locker, (String)"locker cannot be null");
        Assert.notNull((Object)auth, (String)"auth cannot be null");
        this.locker = locker;
        this.auth = auth;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        LockParticipant participant = invocation.getMethod().getAnnotation(LockParticipant.class);
        if (participant != null) {
            return this.invokeWithIntecept(invocation);
        }
        return invocation.proceed();
    }

    private Object invokeWithIntecept(MethodInvocation invocation) throws Throwable {
        Object entity = invocation.getArguments()[0];
        Field idField = org.springframework.data.util.ReflectionUtils.findField(entity.getClass(), (ReflectionUtils.DescribedFieldFilter)ID_FILTER);
        if (idField == null) {
            idField = org.springframework.data.util.ReflectionUtils.findField(entity.getClass(), (ReflectionUtils.DescribedFieldFilter)DATA_ID_FILTER);
        }
        if (idField == null) {
            return invocation.proceed();
        }
        ReflectionUtils.makeAccessible((Field)idField);
        Object id = ReflectionUtils.getField((Field)idField, (Object)entity);
        if (this.locker.lockOwner(id) == null || this.locker.isLockOwner(id, (Principal)this.auth.getAuthentication())) {
            return invocation.proceed();
        }
        throw new LockOwnerException("Not lock owner");
    }
}

