/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski;

import com.github.paweladamski.HttpClientMockBuilder;
import com.github.paweladamski.HttpResponseProxy;
import com.github.paweladamski.Rule;
import com.github.paweladamski.condition.HostCondition;
import com.github.paweladamski.condition.HttpMethodCondition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class HttpClientMock
extends CloseableHttpClient {
    private final List<Rule> rules = new ArrayList<Rule>();
    private final String host;

    public HttpClientMock() {
        this("");
    }

    public HttpClientMock(String host) {
        this.host = host;
    }

    public HttpClientMockBuilder onGet(String url) {
        return this.newRule("GET", url);
    }

    public HttpClientMockBuilder onPost(String url) {
        return this.newRule("POST", url);
    }

    public HttpClientMockBuilder onPut(String url) {
        return this.newRule("PUT", url);
    }

    public HttpClientMockBuilder onDelete(String url) {
        return this.newRule("DELETE", url);
    }

    public HttpClientMockBuilder onHead(String url) {
        return this.newRule("HEAD", url);
    }

    public HttpClientMockBuilder onOptions(String url) {
        return this.newRule("OPTIONS", url);
    }

    public HttpClientMockBuilder onPatch(String url) {
        return this.newRule("PATCH", url);
    }

    private HttpClientMockBuilder newRule(String method, String url) {
        Rule rule = new Rule();
        this.rules.add(rule);
        rule.addCondition(new HttpMethodCondition(method));
        rule.addCondition(new HostCondition(this.host + url));
        return new HttpClientMockBuilder(rule);
    }

    protected CloseableHttpResponse doExecute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException {
        Rule rule = this.rules.stream().filter(r -> r.matches(httpHost, httpRequest, httpContext)).reduce((a, b) -> b).orElse(Rule.NOT_FOUND);
        HttpResponse response = rule.nextResponse();
        return new HttpResponseProxy(response);
    }

    public void close() throws IOException {
    }

    public HttpParams getParams() {
        return null;
    }

    public ClientConnectionManager getConnectionManager() {
        return null;
    }
}

