/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski;

import com.github.paweladamski.HttpClientMock;
import com.github.paweladamski.Rule;
import com.github.paweladamski.action.ExceptionAction;
import com.github.paweladamski.action.StatusResponse;
import com.github.paweladamski.action.StringResponse;
import com.github.paweladamski.condition.BodyMatcher;
import com.github.paweladamski.condition.HeaderCondition;
import com.github.paweladamski.condition.ParameterCondition;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class HttpClientMockBuilder
extends HttpClientMock {
    private final Rule newRule;

    public HttpClientMockBuilder(Rule rule) {
        this.newRule = rule;
    }

    public HttpClientMockBuilder withHeader(String header, String value) {
        this.newRule.addCondition(new HeaderCondition(header, (Matcher<String>)Matchers.equalTo((Object)value)));
        return this;
    }

    public HttpClientMockBuilder withParameter(String parameter, String value) {
        this.newRule.addCondition(new ParameterCondition(parameter, (Matcher<String>)Matchers.equalTo((Object)value)));
        return this;
    }

    public HttpClientMockBuilder doReturn(String response) {
        this.newRule.addAction(new StringResponse(response));
        return this;
    }

    public void doReturnStatus(int statusCode) {
        this.newRule.addAction(new StatusResponse(statusCode));
    }

    public HttpClientMockBuilder doThrowException(IOException e) {
        this.newRule.addAction(new ExceptionAction(e));
        return this;
    }

    public HttpClientMockBuilder withBody(Matcher<String> foo) {
        this.newRule.addCondition(new BodyMatcher(foo));
        return this;
    }
}

