/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski;

import com.github.paweladamski.action.Action;
import com.github.paweladamski.action.StatusResponse;
import com.github.paweladamski.condition.Condition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;

public class Rule {
    public static final Rule NOT_FOUND = new Rule();
    Queue<Action> actions = new LinkedList<Action>();
    List<Condition> conditions = new ArrayList<Condition>();

    void addAction(Action o) {
        this.actions.add(o);
    }

    void addCondition(Condition o) {
        this.conditions.add(o);
    }

    boolean matches(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        return this.conditions.stream().allMatch(c -> c.matches(httpHost, httpRequest, httpContext));
    }

    HttpResponse nextResponse() throws IOException {
        Action action = this.actions.size() > 1 ? this.actions.poll() : this.actions.peek();
        return action.getResponse();
    }

    static {
        NOT_FOUND.addAction(new StatusResponse(404));
    }
}

