/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.grammar.smalltalk;

import org.petitparser.parser.Parser;
import org.petitparser.parser.primitive.CharacterParser;
import org.petitparser.parser.primitive.EpsilonParser;
import org.petitparser.parser.primitive.StringParser;
import org.petitparser.tools.GrammarDefinition;

public class SmalltalkDefinition
extends GrammarDefinition {
    public SmalltalkDefinition() {
        this.other();
        this.number();
        this.smalltalk();
    }

    private void other() {
        this.def("whitespace", (Parser)CharacterParser.whitespace().or(new Parser[]{this.ref("comment")}));
        this.def("comment", (Parser)CharacterParser.of((char)'\"').seq(new Parser[]{CharacterParser.any().starLazy((Parser)CharacterParser.of((char)'\"'))}).seq(new Parser[]{CharacterParser.of((char)'\"')}));
    }

    private void number() {
        this.def("number", (Parser)CharacterParser.of((char)'-').optional().seq(new Parser[]{this.ref("positiveNumber")}));
        this.def("positiveNumber", (Parser)this.ref("scaledDecimal").or(new Parser[]{this.ref("float")}).or(new Parser[]{this.ref("integer")}));
        this.def("integer", (Parser)this.ref("radixInteger").or(new Parser[]{this.ref("decimalInteger")}));
        this.def("decimalInteger", this.ref("digits"));
        this.def("digits", CharacterParser.digit().plus());
        this.def("radixInteger", (Parser)this.ref("radixSpecifier").seq(new Parser[]{CharacterParser.of((char)'r')}).seq(new Parser[]{this.ref("radixDigits")}));
        this.def("radixSpecifier", this.ref("digits"));
        this.def("radixDigits", CharacterParser.pattern((String)"0-9A-Z").plus());
        this.def("float", (Parser)this.ref("mantissa").seq(new Parser[]{this.ref("exponentLetter").seq(new Parser[]{this.ref("exponent")}).optional()}));
        this.def("mantissa", (Parser)this.ref("digits").seq(new Parser[]{CharacterParser.of((char)'.')}).seq(new Parser[]{this.ref("digits")}));
        this.def("exponent", (Parser)CharacterParser.of((char)'-').seq(new Parser[]{this.ref("decimalInteger")}));
        this.def("exponentLetter", (Parser)CharacterParser.pattern((String)"edq"));
        this.def("scaledDecimal", (Parser)this.ref("scaledMantissa").seq(new Parser[]{CharacterParser.of((char)'s')}).seq(new Parser[]{this.ref("fractionalDigits").optional()}));
        this.def("scaledMantissa", (Parser)this.ref("decimalInteger").or(new Parser[]{this.ref("mantissa")}));
        this.def("fractionalDigits", this.ref("decimalInteger"));
    }

    private Parser token(Object input) {
        Parser parser;
        if (input instanceof Parser) {
            parser = (Parser)input;
        } else if (input instanceof Character) {
            parser = CharacterParser.of((char)((Character)input).charValue());
        } else if (input instanceof String) {
            parser = StringParser.of((String)((String)input));
        } else {
            throw new IllegalStateException("Object not parsable: " + input);
        }
        return parser.token().trim(this.ref("whitespace"));
    }

    void smalltalk() {
        this.def("array", (Parser)this.token("{").seq(new Parser[]{this.ref("expression").separatedBy(this.ref("periodToken")).seq(new Parser[]{this.ref("periodToken").optional()}).optional()}).seq(new Parser[]{this.token("}")}));
        this.def("arrayItem", (Parser)this.ref("literal").or(new Parser[]{this.ref("symbolLiteralArray")}).or(new Parser[]{this.ref("arrayLiteralArray")}).or(new Parser[]{this.ref("byteLiteralArray")}));
        this.def("arrayLiteral", (Parser)this.token("#(").seq(new Parser[]{this.ref("arrayItem").star()}).seq(new Parser[]{this.token(")")}));
        this.def("arrayLiteralArray", (Parser)this.token("(").seq(new Parser[]{this.ref("arrayItem").star()}).seq(new Parser[]{this.token(")")}));
        this.def("assignment", (Parser)this.ref("variable").seq(new Parser[]{this.ref("assignmentToken")}));
        this.def("assignmentToken", this.token(":="));
        this.def("binary", CharacterParser.pattern((String)"!%&*+,-/<=>?@\\|~").plus());
        this.def("binaryExpression", (Parser)this.ref("unaryExpression").seq(new Parser[]{this.ref("binaryMessage").star()}));
        this.def("binaryMessage", (Parser)this.ref("binaryToken").seq(new Parser[]{this.ref("unaryExpression")}));
        this.def("binaryMethod", (Parser)this.ref("binaryToken").seq(new Parser[]{this.ref("variable")}));
        this.def("binaryPragma", (Parser)this.ref("binaryToken").seq(new Parser[]{this.ref("arrayItem")}));
        this.def("binaryToken", this.token(this.ref("binary")));
        this.def("block", (Parser)this.token("[").seq(new Parser[]{this.ref("blockBody")}).seq(new Parser[]{this.token("]")}));
        this.def("blockArgument", (Parser)this.token(":").seq(new Parser[]{this.ref("variable")}));
        this.def("blockArguments", (Parser)this.ref("blockArgumentsWith").or(new Parser[]{this.ref("blockArgumentsWithout")}));
        this.def("blockArgumentsWith", (Parser)this.ref("blockArgument").plus().seq(new Parser[]{this.token("|").or(new Parser[]{this.token("]").and()})}));
        this.def("blockArgumentsWithout", (Parser)new EpsilonParser());
        this.def("blockBody", (Parser)this.ref("blockArguments").seq(new Parser[]{this.ref("sequence")}));
        this.def("byteLiteral", (Parser)this.token("#[").seq(new Parser[]{this.ref("numberLiteral").star()}).seq(new Parser[]{this.token("]")}));
        this.def("byteLiteralArray", (Parser)this.token("[").seq(new Parser[]{this.ref("numberLiteral").star()}).seq(new Parser[]{this.token("]")}));
        this.def("cascadeExpression", (Parser)this.ref("keywordExpression").seq(new Parser[]{this.ref("cascadeMessage").star()}));
        this.def("cascadeMessage", (Parser)this.token(";").seq(new Parser[]{this.ref("message")}));
        this.def("char", (Parser)CharacterParser.of((char)'$').seq(new Parser[]{CharacterParser.any()}));
        this.def("charLiteral", this.ref("charToken"));
        this.def("charToken", this.token(this.ref("char")));
        this.def("expression", (Parser)this.ref("assignment").star().seq(new Parser[]{this.ref("cascadeExpression")}));
        this.def("falseLiteral", this.ref("falseToken"));
        this.def("falseToken", (Parser)this.token("false").seq(new Parser[]{CharacterParser.word().not()}));
        this.def("identifier", (Parser)CharacterParser.pattern((String)"a-zA-Z_").seq(new Parser[]{CharacterParser.pattern((String)"a-zA-Z0-9_").star()}));
        this.def("identifierToken", this.token(this.ref("identifier")));
        this.def("keyword", (Parser)this.ref("identifier").seq(new Parser[]{CharacterParser.of((char)':')}));
        this.def("keywordExpression", (Parser)this.ref("binaryExpression").seq(new Parser[]{this.ref("keywordMessage").optional()}));
        this.def("keywordMessage", this.ref("keywordToken").seq(new Parser[]{this.ref("binaryExpression")}).plus());
        this.def("keywordMethod", this.ref("keywordToken").seq(new Parser[]{this.ref("variable")}).plus());
        this.def("keywordPragma", this.ref("keywordToken").seq(new Parser[]{this.ref("arrayItem")}).plus());
        this.def("keywordToken", this.token(this.ref("keyword")));
        this.def("literal", (Parser)this.ref("numberLiteral").or(new Parser[]{this.ref("stringLiteral")}).or(new Parser[]{this.ref("charLiteral")}).or(new Parser[]{this.ref("arrayLiteral")}).or(new Parser[]{this.ref("byteLiteral")}).or(new Parser[]{this.ref("symbolLiteral")}).or(new Parser[]{this.ref("nilLiteral")}).or(new Parser[]{this.ref("trueLiteral")}).or(new Parser[]{this.ref("falseLiteral")}));
        this.def("message", (Parser)this.ref("keywordMessage").or(new Parser[]{this.ref("binaryMessage")}).or(new Parser[]{this.ref("unaryMessage")}));
        this.def("method", (Parser)this.ref("methodDeclaration").seq(new Parser[]{this.ref("methodSequence")}));
        this.def("methodDeclaration", (Parser)this.ref("keywordMethod").or(new Parser[]{this.ref("unaryMethod")}).or(new Parser[]{this.ref("binaryMethod")}));
        this.def("methodSequence", (Parser)this.ref("periodToken").star().seq(new Parser[]{this.ref("pragmas")}).seq(new Parser[]{this.ref("periodToken").star()}).seq(new Parser[]{this.ref("temporaries")}).seq(new Parser[]{this.ref("periodToken").star()}).seq(new Parser[]{this.ref("pragmas")}).seq(new Parser[]{this.ref("periodToken").star()}).seq(new Parser[]{this.ref("statements")}));
        this.def("multiword", this.ref("keyword").plus());
        this.def("nilLiteral", this.ref("nilToken"));
        this.def("nilToken", (Parser)this.token("nil").seq(new Parser[]{CharacterParser.word().not()}));
        this.def("numberLiteral", this.ref("numberToken"));
        this.def("numberToken", this.token(this.ref("number")));
        this.def("parens", (Parser)this.token("(").seq(new Parser[]{this.ref("expression")}).seq(new Parser[]{this.token(")")}));
        this.def("period", (Parser)CharacterParser.of((char)'.'));
        this.def("periodToken", this.token(this.ref("period")));
        this.def("pragma", (Parser)this.token("<").seq(new Parser[]{this.ref("pragmaMessage")}).seq(new Parser[]{this.token(">")}));
        this.def("pragmaMessage", (Parser)this.ref("keywordPragma").or(new Parser[]{this.ref("unaryPragma")}).or(new Parser[]{this.ref("binaryPragma")}));
        this.def("pragmas", this.ref("pragma").star());
        this.def("primary", (Parser)this.ref("literal").or(new Parser[]{this.ref("variable")}).or(new Parser[]{this.ref("block")}).or(new Parser[]{this.ref("parens")}).or(new Parser[]{this.ref("array")}));
        this.def("return", (Parser)this.token("^").seq(new Parser[]{this.ref("expression")}));
        this.def("sequence", (Parser)this.ref("temporaries").seq(new Parser[]{this.ref("periodToken").star()}).seq(new Parser[]{this.ref("statements")}));
        this.def("start", this.ref("startMethod"));
        this.def("startMethod", this.ref("method").end());
        this.def("statements", (Parser)this.ref("expression").seq(new Parser[]{this.ref("periodToken").plus().seq(new Parser[]{this.ref("statements")}).or(new Parser[]{this.ref("periodToken").star()})}).or(new Parser[]{this.ref("return").seq(new Parser[]{this.ref("periodToken").star()})}).or(new Parser[]{this.ref("periodToken").star()}));
        this.def("string", (Parser)CharacterParser.of((char)'\'').seq(new Parser[]{StringParser.of((String)"''").or(new Parser[]{CharacterParser.pattern((String)"^'")}).star()}).seq(new Parser[]{CharacterParser.of((char)'\'')}));
        this.def("stringLiteral", this.ref("stringToken"));
        this.def("stringToken", this.token(this.ref("string")));
        this.def("symbol", (Parser)this.ref("unary").or(new Parser[]{this.ref("binary")}).or(new Parser[]{this.ref("multiword")}).or(new Parser[]{this.ref("string")}));
        this.def("symbolLiteral", (Parser)this.token("#").plus().seq(new Parser[]{this.token(this.ref("symbol"))}));
        this.def("symbolLiteralArray", this.token(this.ref("symbol")));
        this.def("temporaries", this.token("|").seq(new Parser[]{this.ref("variable").star()}).seq(new Parser[]{this.token("|")}).optional());
        this.def("trueLiteral", this.ref("trueToken"));
        this.def("trueToken", (Parser)this.token("true").seq(new Parser[]{CharacterParser.word().not()}));
        this.def("unary", (Parser)this.ref("identifier").seq(new Parser[]{CharacterParser.of((char)':').not()}));
        this.def("unaryExpression", (Parser)this.ref("primary").seq(new Parser[]{this.ref("unaryMessage").star()}));
        this.def("unaryMessage", this.ref("unaryToken"));
        this.def("unaryMethod", this.ref("identifierToken"));
        this.def("unaryPragma", this.ref("identifierToken"));
        this.def("unaryToken", this.token(this.ref("unary")));
        this.def("variable", this.ref("identifierToken"));
    }
}

