/*
 * Decompiled with CFR 0.152.
 */
package pl.piomin.logging.commons.wrapper;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class SpringRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] body;
    private Map<String, String[]> parameterMap;

    public SpringRequestWrapper(HttpServletRequest request) {
        super(request);
        this.parameterMap = request.getParameterMap();
        String query = request.getQueryString();
        if (query != null) {
            this.body = query.getBytes();
        } else {
            try {
                this.body = IOUtils.toByteArray((InputStream)request.getInputStream());
            }
            catch (IOException ex) {
                this.body = new byte[0];
            }
        }
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStream(){
            ByteArrayInputStream byteArray;
            {
                this.byteArray = new ByteArrayInputStream(SpringRequestWrapper.this.body);
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return this.byteArray.read();
            }
        };
    }

    public Map<String, String> getAllHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        Collections.list(this.getHeaderNames()).forEach(it -> headers.put((String)it, this.getHeader((String)it)));
        return headers;
    }
}

