/*
 * Decompiled with CFR 0.152.
 */
package com.github.playerforcehd.gcaptchavalidator.captchaverification;

import com.github.playerforcehd.gcaptchavalidator.CaptchaValidationException;
import com.github.playerforcehd.gcaptchavalidator.captchaconfiguration.CaptchaValidationConfiguration;
import com.github.playerforcehd.gcaptchavalidator.captchaverification.CaptchaValidationResult;
import com.github.playerforcehd.gcaptchavalidator.util.Callback;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

public class CaptchaValidationRequest {
    private CaptchaValidationConfiguration captchaValidationConfiguration;
    private ExecutorService requestPool;

    public CaptchaValidationRequest(CaptchaValidationConfiguration captchaValidationConfiguration, ExecutorService requestPool) {
        this.captchaValidationConfiguration = captchaValidationConfiguration;
        this.requestPool = requestPool;
    }

    public void fetchAsync(final Callback<CaptchaValidationResult> callback) {
        this.requestPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CaptchaValidationResult result = CaptchaValidationRequest.this.fetchSync();
                    callback.invoke(result);
                }
                catch (CaptchaValidationException | IOException e) {
                    e.printStackTrace();
                    callback.fail(e);
                }
            }
        });
    }

    public void fetchAsync(final Callback<CaptchaValidationResult> callback, final String response) {
        this.requestPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CaptchaValidationResult result = CaptchaValidationRequest.this.fetchSync(response);
                    callback.invoke(result);
                }
                catch (CaptchaValidationException | IOException e) {
                    e.printStackTrace();
                    callback.fail(e);
                }
            }
        });
    }

    public CaptchaValidationResult fetchSync() throws IOException, CaptchaValidationException {
        String line;
        if (this.captchaValidationConfiguration.getSecret() == null) {
            throw new CaptchaValidationException("The value 'secret' has not been set in the CaptchaValidationConfiguration");
        }
        String secret = this.captchaValidationConfiguration.getSecret();
        if (this.captchaValidationConfiguration.getResponse() == null) {
            throw new CaptchaValidationException("The value 'response' has not been set in the CaptchaValidationConfiguration");
        }
        String response = this.captchaValidationConfiguration.getResponse();
        String remoteIP = null;
        if (this.captchaValidationConfiguration.getRemoteIP() != null) {
            remoteIP = this.captchaValidationConfiguration.getRemoteIP();
        }
        CloseableHttpClient httpClient = HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        HttpPost postData = new HttpPost("https://www.google.com/recaptcha/api/siteverify");
        postData.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36");
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("secret", secret));
        parameters.add(new BasicNameValuePair("response", response));
        if (remoteIP != null) {
            parameters.add(new BasicNameValuePair("remoteip", remoteIP));
        }
        postData.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)postData);
        BufferedReader resultReader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
        StringBuilder jsonResult = new StringBuilder();
        while ((line = resultReader.readLine()) != null) {
            jsonResult.append(line);
        }
        resultReader.close();
        return CaptchaValidationResult.deserializeJSon(jsonResult.toString());
    }

    public CaptchaValidationResult fetchSync(String response) throws IOException, CaptchaValidationException {
        this.captchaValidationConfiguration.setResponse(response);
        return this.fetchSync();
    }

    public CaptchaValidationConfiguration getCaptchaValidationConfiguration() {
        return this.captchaValidationConfiguration;
    }
}

