/*
 * Decompiled with CFR 0.152.
 */
package com.github.playerforcehd.gcaptchavalidator.captchaverification;

import com.github.playerforcehd.gcaptchavalidator.captchaverification.CaptchaValidationError;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

public class CaptchaValidationResult {
    private boolean success;
    private String challengeTS;
    private String hostName;
    private CaptchaValidationError errorCode;

    public CaptchaValidationResult(boolean success, String challengeTS, String hostName, CaptchaValidationError errorCode) {
        this.success = success;
        this.challengeTS = challengeTS;
        this.hostName = hostName;
        this.errorCode = errorCode;
    }

    public static CaptchaValidationResult deserializeJSon(String json) {
        JsonElement jsonElement = new JsonParser().parse(json);
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        boolean success = jsonObject.get("success").getAsBoolean();
        String challengeTS = null;
        if (jsonObject.get("challenge_ts") != null) {
            challengeTS = jsonObject.get("challenge_ts").getAsString();
        }
        String hostName = null;
        if (jsonObject.get("hostname") != null) {
            hostName = jsonObject.get("hostname").getAsString();
        }
        String errorCode = null;
        if (jsonObject.get("error-codes") != null) {
            errorCode = jsonObject.get("error-codes").getAsString();
        }
        CaptchaValidationError captchaValidationError = null;
        if (errorCode != null) {
            captchaValidationError = CaptchaValidationError.parseGoogleJSonErrorCoede(errorCode);
        }
        return new CaptchaValidationResult(success, challengeTS, hostName, captchaValidationError);
    }

    public boolean isValid() {
        return this.success;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getChallengeTS() {
        return this.challengeTS;
    }

    public String getHostName() {
        return this.hostName;
    }

    public CaptchaValidationError getErrorCode() {
        return this.errorCode;
    }
}

