/*
 * Decompiled with CFR 0.152.
 */
package com.github.playerforcehd.gcaptchavalidator.captchaverification;

import com.github.playerforcehd.gcaptchavalidator.CaptchaValidationException;
import com.github.playerforcehd.gcaptchavalidator.captchaconfiguration.CaptchaValidationConfiguration;
import com.github.playerforcehd.gcaptchavalidator.captchaverification.CaptchaValidationResult;
import com.github.playerforcehd.gcaptchavalidator.util.Callback;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class CaptchaValidationRequest {
    private CaptchaValidationConfiguration captchaValidationConfiguration;
    private ExecutorService requestPool;

    public CaptchaValidationRequest(CaptchaValidationConfiguration captchaValidationConfiguration, ExecutorService requestPool) {
        this.captchaValidationConfiguration = captchaValidationConfiguration;
        this.requestPool = requestPool;
    }

    public void fetchAsync(final Callback<CaptchaValidationResult> callback) {
        this.requestPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CaptchaValidationResult result = CaptchaValidationRequest.this.fetchSync();
                    callback.invoke(result);
                }
                catch (CaptchaValidationException | IOException e) {
                    e.printStackTrace();
                    callback.fail(e);
                }
            }
        });
    }

    public void fetchAsync(final Callback<CaptchaValidationResult> callback, final String response) {
        this.requestPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CaptchaValidationResult result = CaptchaValidationRequest.this.fetchSync(response);
                    callback.invoke(result);
                }
                catch (CaptchaValidationException | IOException e) {
                    e.printStackTrace();
                    callback.fail(e);
                }
            }
        });
    }

    public CaptchaValidationResult fetchSync() throws IOException, CaptchaValidationException {
        int c;
        if (this.captchaValidationConfiguration.getSecret() == null) {
            throw new CaptchaValidationException("The value 'secret' has not been set in the CaptchaValidationConfiguration");
        }
        String secret = this.captchaValidationConfiguration.getSecret();
        if (this.captchaValidationConfiguration.getResponse() == null) {
            throw new CaptchaValidationException("The value 'response' has not been set in the CaptchaValidationConfiguration");
        }
        String response = this.captchaValidationConfiguration.getResponse();
        String remoteIP = null;
        if (this.captchaValidationConfiguration.getRemoteIP() != null) {
            remoteIP = this.captchaValidationConfiguration.getRemoteIP();
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("secret", secret);
        params.put("response", response);
        if (remoteIP != null) {
            params.put("remoteip", remoteIP);
        }
        byte[] parsedParams = this.createPostData(params);
        URL url = new URL("https://www.google.com/recaptcha/api/siteverify");
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        httpURLConnection.setRequestProperty("Content-Length", String.valueOf(parsedParams.length));
        httpURLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36");
        httpURLConnection.setDoOutput(true);
        httpURLConnection.getOutputStream().write(parsedParams);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
        StringBuilder stringBuilder = new StringBuilder();
        while ((c = bufferedReader.read()) >= 0) {
            stringBuilder.append((char)c);
        }
        String googleResponse = stringBuilder.toString();
        bufferedReader.close();
        return CaptchaValidationResult.deserializeJSon(googleResponse);
    }

    public CaptchaValidationResult fetchSync(String response) throws IOException, CaptchaValidationException {
        this.captchaValidationConfiguration.setResponse(response);
        return this.fetchSync();
    }

    private byte[] createPostData(Map<String, Object> params) throws UnsupportedEncodingException {
        StringBuilder postData = new StringBuilder();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            if (postData.length() != 0) {
                postData.append('&');
            }
            postData.append(URLEncoder.encode(param.getKey(), "UTF-8"));
            postData.append('=');
            postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
        }
        return postData.toString().getBytes("UTF-8");
    }

    public CaptchaValidationConfiguration getCaptchaValidationConfiguration() {
        return this.captchaValidationConfiguration;
    }
}

