/*
 * Decompiled with CFR 0.152.
 */
package com.github.playerforcehd.gcaptchavalidator.captchaverification;

import com.github.playerforcehd.gcaptchavalidator.captchaverification.CaptchaValidationError;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;

public class CaptchaValidationResult {
    private boolean success;
    private String challengeTS;
    private String hostName;
    private Collection<CaptchaValidationError> errorCodes;

    public CaptchaValidationResult(boolean success, String challengeTS, String hostName, Collection<CaptchaValidationError> errorCode) {
        this.success = success;
        this.challengeTS = challengeTS;
        this.hostName = hostName;
        this.errorCodes = errorCode;
    }

    public static CaptchaValidationResult deserializeJSon(String json) {
        JsonElement jsonElement = new JsonParser().parse(json);
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        boolean success = jsonObject.get("success").getAsBoolean();
        String challengeTS = null;
        if (jsonObject.get("challenge_ts") != null) {
            challengeTS = jsonObject.get("challenge_ts").getAsString();
        }
        String hostName = null;
        if (jsonObject.get("hostname") != null) {
            hostName = jsonObject.get("hostname").getAsString();
        }
        ArrayList<CaptchaValidationError> errorCodes = new ArrayList<CaptchaValidationError>();
        if (jsonObject.get("error-codes") != null) {
            JsonElement errorList = jsonObject.get("error-codes");
            for (int i = errorList.getAsJsonArray().size() - 1; i >= 0; --i) {
                errorCodes.add(CaptchaValidationError.parseGoogleJSonErrorCode(errorList.getAsJsonArray().get(i).getAsString()));
            }
        }
        return new CaptchaValidationResult(success, challengeTS, hostName, errorCodes);
    }

    public boolean isValid() {
        return this.success;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getChallengeTS() {
        return this.challengeTS;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Collection<CaptchaValidationError> getErrorCodes() {
        return this.errorCodes;
    }
}

