package com.podio.item;

import com.fasterxml.jackson.annotation.JsonProperty;

import com.podio.app.Application;

public class ItemMini {

	/**
	 * The id of the item
	 */
	private long id;

	/**
	 * The title of the item. This is made of up one of the fields below, or by
	 * the item name and id
	 */
	private String title;

	/**
	 * The information on who created the first revision of the item
	 */
	private ItemRevision initialRevision;

	/**
	 * The app where the item belongs
	 */
	private Application application;

	@JsonProperty("item_id")
	public long getId() {
		return id;
	}

	@JsonProperty("item_id")
	public void setId(long id) {
		this.id = id;
	}

	@JsonProperty("app")
	public Application getApplication() {
		return application;
	}

	@JsonProperty("app")
	public void setApplication(Application application) {
		this.application = application;
	}

	@JsonProperty("initial_revision")
	public ItemRevision getInitialRevision() {
		return initialRevision;
	}

	@JsonProperty("initial_revision")
	public void setInitialRevision(ItemRevision initialRevision) {
		this.initialRevision = initialRevision;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
}
