/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.explicitboundaries.gemoetry;

import java.util.ArrayList;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import weka.classifiers.functions.explicitboundaries.gemoetry.DotProduct;
import weka.classifiers.functions.explicitboundaries.gemoetry.DotProductEuclidean;
import weka.classifiers.functions.explicitboundaries.gemoetry.DotProductTester;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.tools.InstancesTools;

public class DotProductEuclideanTest {
    DotProduct dotP = null;

    @Before
    public void setUp() throws Exception {
        this.dotP = new DotProductEuclidean();
    }

    @Test
    public void testDotProduct() {
        DotProductTester.testDotProduct(this.dotP);
    }

    @Test
    public void testProjection() {
        ArrayList<Attribute> atts = new ArrayList<Attribute>(3);
        atts.add(new Attribute("X1"));
        atts.add(new Attribute("X2"));
        LinkedList<String> valList = new LinkedList<String>();
        valList.add("1");
        valList.add("2");
        atts.add(new Attribute("Class", valList));
        Instances dataset = new Instances("daataset", atts, 1);
        dataset.setClassIndex(2);
        DenseInstance test1 = new DenseInstance(1.0, new double[]{1.0, 0.0, 1.0});
        test1.setDataset(dataset);
        DenseInstance test2 = new DenseInstance(1.0, new double[]{1.0, 0.0, 2.0});
        test2.setDataset(dataset);
        DenseInstance test3 = new DenseInstance(1.0, new double[]{0.0, 1.0, 1.0});
        test3.setDataset(dataset);
        DenseInstance test4 = new DenseInstance(1.0, new double[]{0.0, 1.0, 2.0});
        test4.setDataset(dataset);
        DenseInstance test5 = new DenseInstance(1.0, new double[]{6.0, 6.0, 2.0});
        test5.setDataset(dataset);
        DenseInstance test6 = new DenseInstance(1.0, new double[]{6.0, 0.0, 2.0});
        test6.setDataset(dataset);
        DenseInstance test7 = new DenseInstance(1.0, new double[]{0.0, 6.0, 2.0});
        test7.setDataset(dataset);
        DotProductEuclidean dotP = new DotProductEuclidean();
        try {
            Instance res1 = dotP.projection((Instance)test5, (Instance)test1);
            Assert.assertTrue((String)"Check projection 1", (boolean)InstancesTools.checkEquall((Instance)res1, (Instance)test6, (boolean)false));
            Assert.assertFalse((String)"Check projection 1 -F ", (boolean)InstancesTools.checkEquall((Instance)res1, (Instance)test7, (boolean)false));
            res1 = dotP.projection((Instance)test5, (Instance)test3);
            Assert.assertTrue((String)"Check projection 2", (boolean)InstancesTools.checkEquall((Instance)res1, (Instance)test7, (boolean)false));
            Assert.assertFalse((String)"Check projection 2 -F ", (boolean)InstancesTools.checkEquall((Instance)res1, (Instance)test6, (boolean)false));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception has been caught");
        }
    }
}

