/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.explicitboundaries.gemoetry;

import java.util.ArrayList;
import java.util.LinkedList;
import org.junit.Assert;
import weka.classifiers.functions.explicitboundaries.gemoetry.DotProduct;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class DotProductTester {
    public static void testDotProduct(DotProduct dotP) {
        ArrayList<Attribute> atts = new ArrayList<Attribute>(3);
        atts.add(new Attribute("X1"));
        atts.add(new Attribute("X2"));
        LinkedList<String> valList = new LinkedList<String>();
        valList.add("1");
        valList.add("2");
        atts.add(new Attribute("Class", valList));
        Instances dataset = new Instances("daataset", atts, 1);
        dataset.setClassIndex(2);
        DenseInstance test1 = new DenseInstance(1.0, new double[]{1.0, 1.0, 1.0});
        test1.setDataset(dataset);
        DenseInstance test2 = new DenseInstance(1.0, new double[]{0.5, 0.5, 2.0});
        test2.setDataset(dataset);
        DenseInstance test3 = new DenseInstance(1.0, new double[]{0.5, 0.5, 1.0});
        test3.setDataset(dataset);
        try {
            double d1 = dotP.dotProduct((Instance)test1, (Instance)test2);
            double d2 = dotP.dotProduct((Instance)test1, (Instance)test3);
            Assert.assertEquals((double)d1, (double)d2, (double)1.0E-6);
            d1 = dotP.dotProduct((Instance)test1, (Instance)test2);
            d2 = dotP.dotProduct((Instance)test2, (Instance)test1);
            Assert.assertEquals((double)d1, (double)d2, (double)1.0E-6);
            double s1 = 2.0;
            double s2 = 3.0;
            DenseInstance test4 = new DenseInstance(1.0, new double[]{s1, s1, 1.0});
            test4.setDataset(dataset);
            DenseInstance test5 = new DenseInstance(1.0, new double[]{s2, s2, 1.0});
            test5.setDataset(dataset);
            d1 = dotP.dotProduct((Instance)test1, (Instance)test1);
            d2 = dotP.dotProduct((Instance)test4, (Instance)test5);
            Assert.assertEquals((double)(d1 * s1 * s2), (double)d2, (double)1.0E-16);
            DenseInstance test6 = new DenseInstance(1.0, new double[]{1.0, 0.0, 1.0});
            test6.setDataset(dataset);
            DenseInstance test7 = new DenseInstance(1.0, new double[]{0.0, 1.0, 1.0});
            test7.setDataset(dataset);
            d1 = dotP.dotProduct((Instance)test6, (Instance)test7);
            Assert.assertEquals((double)d1, (double)0.0, (double)1.0E-6);
            DenseInstance test8 = new DenseInstance(1.0, new double[]{s1 + s2, s1 + s2, 1.0});
            test8.setDataset(dataset);
            d1 = dotP.dotProduct((Instance)test1, (Instance)test8);
            d2 = dotP.dotProduct((Instance)test1, (Instance)test4) + dotP.dotProduct((Instance)test1, (Instance)test5);
            Assert.assertEquals((double)d1, (double)d2, (double)1.0E-6);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"An exception has been thrown");
        }
    }
}

