/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.explicitboundaries.gemoetry;

import java.util.ArrayList;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import weka.classifiers.functions.explicitboundaries.gemoetry.DotProduct;
import weka.classifiers.functions.explicitboundaries.gemoetry.GrammShmidtOrthonormal;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class GrammShmidtOrthonormalTest {
    @Test
    public void test() {
        ArrayList<Attribute> atts = new ArrayList<Attribute>(3);
        atts.add(new Attribute("X1"));
        atts.add(new Attribute("X2"));
        LinkedList<String> valList = new LinkedList<String>();
        valList.add("1");
        valList.add("2");
        atts.add(new Attribute("Class", valList));
        Instances dataset = new Instances("daataset", atts, 1);
        dataset.setClassIndex(2);
        DenseInstance test1 = new DenseInstance(1.0, new double[]{1.0, 1.0, 1.0});
        test1.setDataset(dataset);
        DenseInstance test2 = new DenseInstance(1.0, new double[]{1.0, -0.5, 1.0});
        test2.setDataset(dataset);
        Instance[] base = new Instance[]{test1, test2};
        GrammShmidtOrthonormal gs = new GrammShmidtOrthonormal();
        DotProduct dp = gs.getDotProd();
        double dotp = 0.0;
        try {
            Instance[] nBase = gs.createOrthonormalBase(base);
            Assert.assertEquals((String)"Base size", (long)nBase.length, (long)base.length);
            int i = 0;
            while (i < nBase.length) {
                Assert.assertEquals((String)"Length", (double)1.0, (double)dp.norm(nBase[i]), (double)1.0E-6);
                ++i;
            }
            i = 0;
            while (i < nBase.length) {
                int j = i + 1;
                while (j < nBase.length) {
                    Assert.assertEquals((String)"Orthogonality", (double)0.0, (double)dp.dotProduct(nBase[i], nBase[j]), (double)1.0E-6);
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"An exception has been caught");
        }
    }
}

