/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.explicitboundaries.gemoetry;

import java.util.ArrayList;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import weka.classifiers.functions.explicitboundaries.gemoetry.DotProduct;
import weka.classifiers.functions.explicitboundaries.gemoetry.DotProductEuclidean;
import weka.classifiers.functions.explicitboundaries.gemoetry.Plane;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.tools.InstancesTools;

public class PlaneTest {
    Plane plane = null;
    Instances dataset = null;

    @Before
    public void setUp() throws Exception {
        ArrayList<Attribute> atts = new ArrayList<Attribute>(3);
        atts.add(new Attribute("X1"));
        atts.add(new Attribute("X2"));
        LinkedList<String> valList = new LinkedList<String>();
        valList.add("1");
        valList.add("2");
        atts.add(new Attribute("Class", valList));
        this.dataset = new Instances("daataset", atts, 1);
        this.dataset.setClassIndex(2);
        this.plane = new Plane(this.dataset);
    }

    @Test
    public void testDistanceToPlane() {
        double offset = -1.0;
        DenseInstance nV = new DenseInstance(1.0, new double[]{1.0, 0.0, 1.0});
        nV.setDataset(this.dataset);
        DenseInstance test1 = new DenseInstance(1.0, new double[]{2.0, 0.0, 1.0});
        test1.setDataset(this.dataset);
        DenseInstance test2 = new DenseInstance(1.0, new double[]{-2.0, 0.0, 1.0});
        test2.setDataset(this.dataset);
        try {
            this.plane.setNormalVector((Instance)nV);
            this.plane.setOffset(offset);
            this.plane.setNormalizeDistance(false);
            double val = 1.0;
            double dist = this.plane.distanceToPlane((Instance)test1);
            Assert.assertEquals((String)"Plane dist 1, t1", (double)val, (double)dist, (double)1.0E-6);
            Assert.assertEquals((double)3.0, (double)this.plane.distanceToPlane((Instance)test2), (double)1.0E-6);
            Assert.assertTrue((this.plane.sideOfThePlane((Instance)test1) > 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((this.plane.sideOfThePlane((Instance)test2) < 0.0 ? 1 : 0) != 0);
            Assert.assertEquals((String)"Plane dist 1, t2", (double)val, (double)this.plane.distanceToPlane((Instance)test1), (double)1.0E-6);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"An exception has been thrown");
        }
    }

    @Test
    public void testSetNormalVector() {
        Instance normVec = null;
        normVec = this.plane.getNormalVector();
        Assert.assertNotNull((Object)normVec);
        Assert.assertTrue((boolean)this.dataset.checkInstance(normVec));
        DenseInstance test = new DenseInstance(1.5, new double[]{1.4, -6.0, 1.0});
        test.setDataset(this.dataset);
        try {
            this.plane.setNormalVector((Instance)test);
            normVec = this.plane.getNormalVector();
            Assert.assertTrue((boolean)normVec.equalHeaders((Instance)test));
            Assert.assertEquals((Object)test, (Object)normVec);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"An exception has been thrown");
        }
    }

    @Test
    public void testSetOffset() {
        double offset = 0.0;
        offset = this.plane.getOffset();
        Assert.assertFalse((String)"NaN", (boolean)Double.isNaN(offset));
        Assert.assertFalse((String)"Infinity", (boolean)Double.isInfinite(offset));
        offset = 6.0;
        this.plane.setOffset(offset);
        Assert.assertEquals((double)offset, (double)this.plane.getOffset(), (double)1.0E-6);
    }

    @Test
    public void testGetDotProduct() {
        DotProduct dp = this.plane.getDotProduct();
        Assert.assertNotNull((Object)dp);
        Assert.assertTrue((boolean)(dp instanceof DotProductEuclidean));
        DotProductEuclidean dpe = new DotProductEuclidean();
        this.plane.setDotProduct((DotProduct)dpe);
        Assert.assertEquals((Object)dpe, (Object)this.plane.getDotProduct());
    }

    @Test
    public void testGetDataHeader() {
        Assert.assertEquals((Object)this.dataset, (Object)this.plane.getDataHeader());
    }

    @Test
    public void testPlaneBase() {
        DenseInstance nV = new DenseInstance(1.0, new double[]{1.0, 0.0, 1.0});
        nV.setDataset(this.dataset);
        DenseInstance base = new DenseInstance(1.0, new double[]{0.0, 1.0, 1.0});
        base.setDataset(this.dataset);
        DenseInstance tInst = new DenseInstance(1.0, new double[]{6.5, -3.0, 1.0});
        tInst.setDataset(this.dataset);
        DenseInstance tInstProj = new DenseInstance(1.0, new double[]{0.0, -3.0, 1.0});
        tInstProj.setDataset(this.dataset);
        Instance[] b1 = null;
        Instance projT = null;
        try {
            this.plane.setNormalVector((Instance)nV);
            b1 = this.plane.planeBase;
            Assert.assertTrue((String)"Check plane base", (boolean)InstancesTools.checkEquall((Instance)base, (Instance)b1[0], (boolean)false));
            projT = this.plane.projectOnPlane((Instance)tInst);
            Assert.assertTrue((String)"Check plane projection", (boolean)InstancesTools.checkEquall((Instance)projT, (Instance)tInstProj, (boolean)false));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception has been caught");
        }
    }
}

