/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.explicitboundaries.models;

import java.util.ArrayList;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import weka.classifiers.functions.explicitboundaries.DecisionBoundaryPlane;
import weka.classifiers.functions.explicitboundaries.gemoetry.Plane;
import weka.classifiers.functions.explicitboundaries.models.MajorityPlaneBoundaryModel;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.tools.InstancesTools;

public class MajorityPlaneBoundaryModelTest {
    @Test
    public void test() {
        ArrayList<Attribute> atts = new ArrayList<Attribute>(3);
        atts.add(new Attribute("X1"));
        atts.add(new Attribute("X2"));
        LinkedList<String> valList = new LinkedList<String>();
        valList.add("1");
        valList.add("2");
        atts.add(new Attribute("Class", valList));
        Instances dataset = new Instances("daataset", atts, 1);
        dataset.setClassIndex(2);
        DenseInstance nV = new DenseInstance(1.0, new double[]{0.0, 0.0, 1.0});
        nV.setDataset(dataset);
        DenseInstance test = new DenseInstance(1.0, new double[]{1.0, 5.0, 1.0});
        test.setDataset(dataset);
        Instance proj = null;
        MajorityPlaneBoundaryModel mpbm = new MajorityPlaneBoundaryModel();
        DecisionBoundaryPlane decPlane = null;
        Plane pl = null;
        try {
            mpbm.buildDefaultModelPlane(dataset);
            decPlane = mpbm.getPlaneModel();
            pl = decPlane.getDecisionPlane();
            Assert.assertEquals((String)"Offset", (double)-1.0, (double)pl.getOffset(), (double)1.0E-6);
            Assert.assertTrue((String)"Normal vector is zero", (boolean)InstancesTools.checkEquall((Instance)nV, (Instance)pl.getNormalVector(), (boolean)false));
            proj = pl.projectOnPlane((Instance)test);
            Assert.assertTrue((String)"Projected vector is zero", (boolean)InstancesTools.checkEquall((Instance)nV, (Instance)proj, (boolean)false));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception has been caught");
        }
    }
}

