/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivebus.library;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;

public class Event {
    private static final String EMPTY_STRING = "";
    private String id;
    private String name;
    private Serializable data;

    private Event(String id, String name, Serializable data) {
        this.id = id;
        this.name = name;
        this.data = data;
    }

    private Event(String id, String name) {
        this(id, name, null);
    }

    private Event(String name) {
        this(UUID.randomUUID().toString(), name);
    }

    private Event() {
        this(EMPTY_STRING);
    }

    public static Event create(String name, Serializable data) {
        return new Event(UUID.randomUUID().toString(), name, data);
    }

    public static Event create(String id, String name, Serializable data) {
        return new Event(id, name, data);
    }

    public static Event create(String id, String name) {
        return new Event(id, name);
    }

    public static Event create(String name) {
        return new Event(name);
    }

    public static Event create() {
        return new Event();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Serializable getData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public String toString() {
        return "Event {id='" + this.id + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.id, event.id) && Objects.equals(this.name, event.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }
}

