/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.autoconfigure;

import com.jarvis.cache.CacheHandler;
import com.jarvis.cache.ICacheManager;
import com.jarvis.cache.annotation.Cache;
import com.jarvis.cache.annotation.CacheDelete;
import com.jarvis.cache.annotation.CacheDeleteTransactional;
import com.jarvis.cache.autoconfigure.AutoloadCacheManageConfiguration;
import com.jarvis.cache.autoconfigure.AutoloadCacheProperties;
import com.jarvis.cache.autoconfigure.MethodAnnotationPointcutAdvisor;
import com.jarvis.cache.clone.ICloner;
import com.jarvis.cache.interceptor.CacheDeleteInterceptor;
import com.jarvis.cache.interceptor.CacheDeleteTransactionalInterceptor;
import com.jarvis.cache.interceptor.CacheMethodInterceptor;
import com.jarvis.cache.script.AbstractScriptParser;
import com.jarvis.cache.serializer.ISerializer;
import javax.annotation.PostConstruct;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.autoproxy.AbstractAdvisorAutoProxyCreator;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration
@ConditionalOnClass(value={CacheHandler.class})
@AutoConfigureAfter(value={AutoloadCacheManageConfiguration.class})
public class AutoloadCacheAutoConfigure {
    private static final String VALIDATOR_BEAN_NAME = "autoloadCacheAutoConfigurationValidator";
    @Autowired
    private AutoloadCacheProperties config;

    @Bean(name={"autoloadCacheAutoConfigurationValidator"})
    public CacheManagerValidator autoloadCacheAutoConfigurationValidator() {
        return new CacheManagerValidator();
    }

    @ConditionalOnMissingBean(value={CacheHandler.class})
    @ConditionalOnBean(value={ICacheManager.class, AbstractScriptParser.class, ICloner.class})
    @Bean(destroyMethod="destroy")
    public CacheHandler autoloadCacheHandler(ICacheManager cacheManager, AbstractScriptParser scriptParser, ICloner cloner) {
        return new CacheHandler(cacheManager, scriptParser, this.config.getConfig(), cloner);
    }

    @Bean
    @ConditionalOnBean(value={CacheHandler.class})
    public CacheMethodInterceptor autoloadCacheMethodInterceptor(CacheHandler cacheHandler) {
        return new CacheMethodInterceptor(cacheHandler, this.config);
    }

    @Bean
    @ConditionalOnBean(value={CacheHandler.class})
    public CacheDeleteInterceptor autoloadCacheDeleteInterceptor(CacheHandler cacheHandler) {
        return new CacheDeleteInterceptor(cacheHandler, this.config);
    }

    @Bean
    @ConditionalOnBean(value={CacheHandler.class})
    public CacheDeleteTransactionalInterceptor autoloadCacheDeleteTransactionalInterceptor(CacheHandler cacheHandler) {
        return new CacheDeleteTransactionalInterceptor(cacheHandler, this.config);
    }

    @Bean(value={"autoloadCacheAdvisor"})
    @ConditionalOnBean(value={CacheHandler.class})
    public AbstractPointcutAdvisor autoloadCacheAdvisor(CacheMethodInterceptor cacheMethodInterceptor) {
        MethodAnnotationPointcutAdvisor cacheAdvisor = new MethodAnnotationPointcutAdvisor(Cache.class, (Advice)cacheMethodInterceptor);
        cacheAdvisor.setOrder(Integer.MAX_VALUE);
        return cacheAdvisor;
    }

    @Bean(value={"autoloadCacheDeleteAdvisor"})
    @ConditionalOnBean(value={CacheHandler.class})
    public AbstractPointcutAdvisor autoloadCacheDeleteAdvisor(CacheDeleteInterceptor cacheDeleteInterceptor) {
        MethodAnnotationPointcutAdvisor cacheDeleteAdvisor = new MethodAnnotationPointcutAdvisor(CacheDelete.class, (Advice)cacheDeleteInterceptor);
        cacheDeleteAdvisor.setOrder(Integer.MAX_VALUE);
        return cacheDeleteAdvisor;
    }

    @Bean(value={"autoloadCacheDeleteTransactionalAdvisor"})
    @ConditionalOnBean(value={CacheHandler.class})
    public AbstractPointcutAdvisor autoloadCacheDeleteTransactionalAdvisor(CacheDeleteTransactionalInterceptor cacheDeleteTransactionalInterceptor) {
        MethodAnnotationPointcutAdvisor cacheDeleteTransactionalAdvisor = new MethodAnnotationPointcutAdvisor(CacheDeleteTransactional.class, (Advice)cacheDeleteTransactionalInterceptor);
        cacheDeleteTransactionalAdvisor.setOrder(Integer.MAX_VALUE);
        return cacheDeleteTransactionalAdvisor;
    }

    @Bean
    @ConditionalOnBean(value={CacheHandler.class})
    public AbstractAdvisorAutoProxyCreator autoloadCacheAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator proxy = new DefaultAdvisorAutoProxyCreator();
        proxy.setAdvisorBeanNamePrefix("autoloadCache");
        proxy.setProxyTargetClass(this.config.isProxyTargetClass());
        return proxy;
    }

    static class CacheManagerValidator {
        @Autowired(required=false)
        private AbstractScriptParser scriptParser;
        @Autowired(required=false)
        private ISerializer<Object> serializer;
        @Autowired(required=false)
        private ICacheManager cacheManager;

        CacheManagerValidator() {
        }

        @PostConstruct
        public void checkHasCacheManager() {
            Assert.notNull((Object)this.scriptParser, (String)"No script parser could be auto-configured");
            Assert.notNull(this.serializer, (String)"No serializer could be auto-configured");
            Assert.notNull((Object)this.cacheManager, (String)"No cache manager could be auto-configured");
        }
    }
}

