/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.autoconfigure;

import com.jarvis.cache.ICacheManager;
import com.jarvis.cache.autoconfigure.AutoloadCacheProperties;
import com.jarvis.cache.redis.JedisClusterCacheManager;
import com.jarvis.cache.redis.SpringJedisCacheManager;
import com.jarvis.cache.script.AbstractScriptParser;
import com.jarvis.cache.script.OgnlParser;
import com.jarvis.cache.script.SpringELParser;
import com.jarvis.cache.serializer.HessianSerializer;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.cache.serializer.JdkSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.util.ClassUtils;
import redis.clients.jedis.JedisCluster;

@Configuration
@ConditionalOnClass(value={ICacheManager.class})
@EnableConfigurationProperties(value={AutoloadCacheProperties.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class AutoloadCacheManageConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(AutoloadCacheManageConfiguration.class);
    private static final boolean ognlPresent = ClassUtils.isPresent((String)"ognl.Ognl", (ClassLoader)AutoloadCacheManageConfiguration.class.getClassLoader());
    private static final boolean hessianPresent = ClassUtils.isPresent((String)"com.caucho.hessian.io.AbstractSerializerFactory", (ClassLoader)AutoloadCacheManageConfiguration.class.getClassLoader());

    @Bean
    @ConditionalOnMissingBean(value={AbstractScriptParser.class})
    public AbstractScriptParser autoloadCacheScriptParser() {
        OgnlParser res = null;
        if (ognlPresent) {
            res = new OgnlParser();
            logger.debug("OgnlParser auto-configured");
        } else {
            res = new SpringELParser();
            logger.debug("SpringELParser auto-configured");
        }
        return res;
    }

    @Bean
    @ConditionalOnMissingBean(value={ISerializer.class})
    public ISerializer<Object> autoloadCacheSerializer() {
        HessianSerializer res;
        if (hessianPresent) {
            res = new HessianSerializer();
            logger.debug("HessianSerializer auto-configured");
        } else {
            res = new JdkSerializer();
            logger.debug("JdkSerializer auto-configured");
        }
        return res;
    }

    @Bean
    @ConditionalOnMissingBean(value={ICacheManager.class})
    public ICacheManager autoloadCacheCacheManager(AutoloadCacheProperties config, ISerializer<Object> serializer, RedisConnectionFactory connectionFactory) {
        if (null == connectionFactory) {
            return null;
        }
        if (!(connectionFactory instanceof JedisConnectionFactory)) {
            logger.debug("connectionFactory is not JedisConnectionFactory");
            return null;
        }
        RedisConnection redisConnection = null;
        try {
            redisConnection = connectionFactory.getConnection();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        if (null != redisConnection) {
            if (redisConnection instanceof RedisClusterConnection) {
                RedisClusterConnection redisClusterConnection = (RedisClusterConnection)redisConnection;
                JedisCluster jedisCluster = null;
                jedisCluster = (JedisCluster)redisClusterConnection.getNativeConnection();
                if (null != jedisCluster) {
                    JedisClusterCacheManager manager = new JedisClusterCacheManager(serializer);
                    manager.setJedisCluster(jedisCluster);
                    manager.setHashExpire(config.getJedis().getHashExpire());
                    manager.setHashExpireByScript(config.getJedis().isHashExpireByScript());
                    logger.debug("ICacheManager with JedisClusterCacheManager auto-configured," + config.getConfig());
                    return manager;
                }
            } else if (redisConnection instanceof JedisConnection) {
                SpringJedisCacheManager manager = new SpringJedisCacheManager(serializer);
                manager.setRedisConnectionFactory((JedisConnectionFactory)connectionFactory);
                manager.setHashExpire(config.getJedis().getHashExpire());
                manager.setHashExpireByScript(config.getJedis().isHashExpireByScript());
                logger.debug("ICacheManager with SpringJedisCacheManager auto-configured," + config.getConfig());
                return manager;
            }
        }
        return null;
    }
}

