/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.autoconfigure;

import com.jarvis.cache.to.AutoLoadConfig;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="autoload.cache")
public class AutoloadCacheProperties {
    private AutoLoadConfig config = new AutoLoadConfig();
    private JedisCacheManagerConfig jedis = new JedisCacheManagerConfig();
    @Autowired
    private Environment env;
    private boolean namespaceEnable = true;
    private boolean proxyTargetClass = false;
    private boolean enable = true;

    @PostConstruct
    public void init() {
        String applicationName;
        String namespace;
        if (this.namespaceEnable && null != this.env && (null == (namespace = this.config.getNamespace()) || namespace.trim().length() == 0) && null != (applicationName = this.env.getProperty("spring.application.name")) && applicationName.trim().length() > 0) {
            this.config.setNamespace(applicationName);
        }
    }

    public AutoLoadConfig getConfig() {
        return this.config;
    }

    public void setConfig(AutoLoadConfig config) {
        this.config = config;
    }

    public JedisCacheManagerConfig getJedis() {
        return this.jedis;
    }

    public void setJedis(JedisCacheManagerConfig jedis) {
        this.jedis = jedis;
    }

    public boolean isNamespaceEnable() {
        return this.namespaceEnable;
    }

    public void setNamespaceEnable(boolean namespaceEnable) {
        this.namespaceEnable = namespaceEnable;
    }

    public boolean isProxyTargetClass() {
        return this.proxyTargetClass;
    }

    public void setProxyTargetClass(boolean proxyTargetClass) {
        this.proxyTargetClass = proxyTargetClass;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    static class JedisCacheManagerConfig {
        private int hashExpire = -1;
        private boolean hashExpireByScript = true;

        JedisCacheManagerConfig() {
        }

        public int getHashExpire() {
            return this.hashExpire;
        }

        public void setHashExpire(int hashExpire) {
            this.hashExpire = hashExpire;
        }

        public boolean isHashExpireByScript() {
            return this.hashExpireByScript;
        }

        public void setHashExpireByScript(boolean hashExpireByScript) {
            this.hashExpireByScript = hashExpireByScript;
        }
    }
}

