/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.autoconfigure;

import com.jarvis.cache.to.AutoLoadConfig;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="autoload.cache")
public class AutoloadCacheProperties {
    public static final String PREFIX = "autoload.cache";
    private AutoLoadConfig config = new AutoLoadConfig();
    private JedisCacheManagerConfig jedis = new JedisCacheManagerConfig();
    @Autowired
    private Environment env;
    private boolean namespaceEnable = true;
    private boolean proxyTargetClass = true;
    private boolean enable = true;
    private boolean enableReadAndWrite = true;
    private boolean enableDelete = true;
    private Integer cacheOrder = Integer.MAX_VALUE;
    private Integer deleteCacheOrder = Integer.MAX_VALUE;
    private Integer deleteCacheTransactionalOrder = 0;
    private String adminUserName = "admin";
    private String adminPassword = "admin";

    @PostConstruct
    public void init() {
        String applicationName;
        String namespace;
        if (this.namespaceEnable && null != this.env && (null == (namespace = this.config.getNamespace()) || namespace.trim().length() == 0) && null != (applicationName = this.env.getProperty("spring.application.name")) && applicationName.trim().length() > 0) {
            this.config.setNamespace(applicationName);
        }
    }

    public AutoLoadConfig getConfig() {
        return this.config;
    }

    public JedisCacheManagerConfig getJedis() {
        return this.jedis;
    }

    public Environment getEnv() {
        return this.env;
    }

    public boolean isNamespaceEnable() {
        return this.namespaceEnable;
    }

    public boolean isProxyTargetClass() {
        return this.proxyTargetClass;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isEnableReadAndWrite() {
        return this.enableReadAndWrite;
    }

    public boolean isEnableDelete() {
        return this.enableDelete;
    }

    public Integer getCacheOrder() {
        return this.cacheOrder;
    }

    public Integer getDeleteCacheOrder() {
        return this.deleteCacheOrder;
    }

    public Integer getDeleteCacheTransactionalOrder() {
        return this.deleteCacheTransactionalOrder;
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setConfig(AutoLoadConfig config) {
        this.config = config;
    }

    public void setJedis(JedisCacheManagerConfig jedis) {
        this.jedis = jedis;
    }

    public void setEnv(Environment env) {
        this.env = env;
    }

    public void setNamespaceEnable(boolean namespaceEnable) {
        this.namespaceEnable = namespaceEnable;
    }

    public void setProxyTargetClass(boolean proxyTargetClass) {
        this.proxyTargetClass = proxyTargetClass;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setEnableReadAndWrite(boolean enableReadAndWrite) {
        this.enableReadAndWrite = enableReadAndWrite;
    }

    public void setEnableDelete(boolean enableDelete) {
        this.enableDelete = enableDelete;
    }

    public void setCacheOrder(Integer cacheOrder) {
        this.cacheOrder = cacheOrder;
    }

    public void setDeleteCacheOrder(Integer deleteCacheOrder) {
        this.deleteCacheOrder = deleteCacheOrder;
    }

    public void setDeleteCacheTransactionalOrder(Integer deleteCacheTransactionalOrder) {
        this.deleteCacheTransactionalOrder = deleteCacheTransactionalOrder;
    }

    public void setAdminUserName(String adminUserName) {
        this.adminUserName = adminUserName;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoloadCacheProperties)) {
            return false;
        }
        AutoloadCacheProperties other = (AutoloadCacheProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AutoLoadConfig this$config = this.getConfig();
        AutoLoadConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        JedisCacheManagerConfig this$jedis = this.getJedis();
        JedisCacheManagerConfig other$jedis = other.getJedis();
        if (this$jedis == null ? other$jedis != null : !((Object)this$jedis).equals(other$jedis)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        if (this.isNamespaceEnable() != other.isNamespaceEnable()) {
            return false;
        }
        if (this.isProxyTargetClass() != other.isProxyTargetClass()) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.isEnableReadAndWrite() != other.isEnableReadAndWrite()) {
            return false;
        }
        if (this.isEnableDelete() != other.isEnableDelete()) {
            return false;
        }
        Integer this$cacheOrder = this.getCacheOrder();
        Integer other$cacheOrder = other.getCacheOrder();
        if (this$cacheOrder == null ? other$cacheOrder != null : !((Object)this$cacheOrder).equals(other$cacheOrder)) {
            return false;
        }
        Integer this$deleteCacheOrder = this.getDeleteCacheOrder();
        Integer other$deleteCacheOrder = other.getDeleteCacheOrder();
        if (this$deleteCacheOrder == null ? other$deleteCacheOrder != null : !((Object)this$deleteCacheOrder).equals(other$deleteCacheOrder)) {
            return false;
        }
        Integer this$deleteCacheTransactionalOrder = this.getDeleteCacheTransactionalOrder();
        Integer other$deleteCacheTransactionalOrder = other.getDeleteCacheTransactionalOrder();
        if (this$deleteCacheTransactionalOrder == null ? other$deleteCacheTransactionalOrder != null : !((Object)this$deleteCacheTransactionalOrder).equals(other$deleteCacheTransactionalOrder)) {
            return false;
        }
        String this$adminUserName = this.getAdminUserName();
        String other$adminUserName = other.getAdminUserName();
        if (this$adminUserName == null ? other$adminUserName != null : !this$adminUserName.equals(other$adminUserName)) {
            return false;
        }
        String this$adminPassword = this.getAdminPassword();
        String other$adminPassword = other.getAdminPassword();
        return !(this$adminPassword == null ? other$adminPassword != null : !this$adminPassword.equals(other$adminPassword));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoloadCacheProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AutoLoadConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        JedisCacheManagerConfig $jedis = this.getJedis();
        result = result * 59 + ($jedis == null ? 43 : ((Object)$jedis).hashCode());
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        result = result * 59 + (this.isNamespaceEnable() ? 79 : 97);
        result = result * 59 + (this.isProxyTargetClass() ? 79 : 97);
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + (this.isEnableReadAndWrite() ? 79 : 97);
        result = result * 59 + (this.isEnableDelete() ? 79 : 97);
        Integer $cacheOrder = this.getCacheOrder();
        result = result * 59 + ($cacheOrder == null ? 43 : ((Object)$cacheOrder).hashCode());
        Integer $deleteCacheOrder = this.getDeleteCacheOrder();
        result = result * 59 + ($deleteCacheOrder == null ? 43 : ((Object)$deleteCacheOrder).hashCode());
        Integer $deleteCacheTransactionalOrder = this.getDeleteCacheTransactionalOrder();
        result = result * 59 + ($deleteCacheTransactionalOrder == null ? 43 : ((Object)$deleteCacheTransactionalOrder).hashCode());
        String $adminUserName = this.getAdminUserName();
        result = result * 59 + ($adminUserName == null ? 43 : $adminUserName.hashCode());
        String $adminPassword = this.getAdminPassword();
        result = result * 59 + ($adminPassword == null ? 43 : $adminPassword.hashCode());
        return result;
    }

    public String toString() {
        return "AutoloadCacheProperties(config=" + this.getConfig() + ", jedis=" + this.getJedis() + ", env=" + this.getEnv() + ", namespaceEnable=" + this.isNamespaceEnable() + ", proxyTargetClass=" + this.isProxyTargetClass() + ", enable=" + this.isEnable() + ", enableReadAndWrite=" + this.isEnableReadAndWrite() + ", enableDelete=" + this.isEnableDelete() + ", cacheOrder=" + this.getCacheOrder() + ", deleteCacheOrder=" + this.getDeleteCacheOrder() + ", deleteCacheTransactionalOrder=" + this.getDeleteCacheTransactionalOrder() + ", adminUserName=" + this.getAdminUserName() + ", adminPassword=" + this.getAdminPassword() + ")";
    }

    static class JedisCacheManagerConfig {
        private int hashExpire = -1;
        private boolean hashExpireByScript = true;

        public int getHashExpire() {
            return this.hashExpire;
        }

        public boolean isHashExpireByScript() {
            return this.hashExpireByScript;
        }

        public void setHashExpire(int hashExpire) {
            this.hashExpire = hashExpire;
        }

        public void setHashExpireByScript(boolean hashExpireByScript) {
            this.hashExpireByScript = hashExpireByScript;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JedisCacheManagerConfig)) {
                return false;
            }
            JedisCacheManagerConfig other = (JedisCacheManagerConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getHashExpire() != other.getHashExpire()) {
                return false;
            }
            return this.isHashExpireByScript() == other.isHashExpireByScript();
        }

        protected boolean canEqual(Object other) {
            return other instanceof JedisCacheManagerConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getHashExpire();
            result = result * 59 + (this.isHashExpireByScript() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "AutoloadCacheProperties.JedisCacheManagerConfig(hashExpire=" + this.getHashExpire() + ", hashExpireByScript=" + this.isHashExpireByScript() + ")";
        }
    }
}

