/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.interceptor;

import com.jarvis.cache.CacheHandler;
import com.jarvis.cache.annotation.Cache;
import com.jarvis.cache.aop.CacheAopProxyChain;
import com.jarvis.cache.autoconfigure.AutoloadCacheProperties;
import com.jarvis.cache.interceptor.aopproxy.CacheAopProxy;
import com.jarvis.cache.util.AopUtil;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;

public class CacheMethodInterceptor
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(CacheMethodInterceptor.class);
    private final CacheHandler cacheHandler;
    private final AutoloadCacheProperties config;

    public CacheMethodInterceptor(CacheHandler cacheHandler, AutoloadCacheProperties config) {
        this.cacheHandler = cacheHandler;
        this.config = config;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!this.config.isEnable()) {
            return invocation.proceed();
        }
        Class<?> cls = AopUtil.getTargetClass(invocation.getThis());
        Method method = invocation.getMethod();
        if (!cls.equals(invocation.getThis().getClass())) {
            logger.debug(invocation.getThis().getClass() + "-->" + cls);
            return invocation.proceed();
        }
        logger.debug(invocation.toString());
        if (method.isAnnotationPresent(Cache.class)) {
            Cache cache = method.getAnnotation(Cache.class);
            logger.debug(invocation.getThis().getClass().getName() + "." + method.getName() + "-->@Cache");
            return this.cacheHandler.proceed((CacheAopProxyChain)new CacheAopProxy(invocation), cache);
        }
        Method specificMethod = AopUtils.getMostSpecificMethod((Method)method, invocation.getThis().getClass());
        if (specificMethod.isAnnotationPresent(Cache.class)) {
            Cache cache = specificMethod.getAnnotation(Cache.class);
            logger.debug(invocation.getThis().getClass().getName() + "." + specificMethod.getName() + "-->@Cache");
            return this.cacheHandler.proceed((CacheAopProxyChain)new CacheAopProxy(invocation), cache);
        }
        return invocation.proceed();
    }
}

