package com.github.rapidark.framework.security;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

import com.github.rapidark.framework.utility.DateUtil;

public class CAUtil
{
  public static KeyPair generateRSAKeyPair()
    throws Exception
  {
    KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA", "BC");
    gen.initialize(1024, new SecureRandom());
    return gen.generateKeyPair();
  }
  
  public static X509Certificate createCA(PublicKey pubKey, PrivateKey privKey, String issuerDN, int limit)
    throws Exception
  {
    Date today = new Date(System.currentTimeMillis());
    Date endDay = DateUtil.addMonth(today, limit);
    SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(
      new DefaultSignatureAlgorithmIdentifierFinder().find(pubKey.getAlgorithm()), pubKey.getEncoded());
    
    X509v3CertificateBuilder builder = new X509v3CertificateBuilder(new X500Name(issuerDN), 
      BigInteger.valueOf(System.currentTimeMillis()), today, endDay, new X500Name(issuerDN), info);
    
    builder.addExtension(X509Extension.subjectKeyIdentifier, false, new SubjectKeyIdentifier(info));
    builder.addExtension(X509Extension.authorityKeyIdentifier, false, new AuthorityKeyIdentifier(info));
    builder.addExtension(X509Extension.basicConstraints, false, new BasicConstraints(true));
    builder.addExtension(X509Extension.keyUsage, false, new KeyUsage(6));
    
    ContentSigner signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider("BC").build(privKey);
    X509CertificateHolder holder = builder.build(signer);
    
    holder.isValidOn(new Date());
    ContentVerifierProvider contentVerifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC")
      .build(pubKey);
    holder.isSignatureValid(contentVerifierProvider);
    
    return new JcaX509CertificateConverter().getCertificate(holder);
  }
}
