package com.github.rapidark.framework.security;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.bouncycastle.jce.provider.JDKX509CertificateFactory;

import com.github.rapidark.framework.Config;
import com.github.rapidark.framework.collection.Mapx;
import com.github.rapidark.framework.extend.ExtendManager;
import com.github.rapidark.framework.extend.plugin.PluginConfig;
import com.github.rapidark.framework.extend.plugin.PluginManager;
import com.github.rapidark.framework.security.SystemInfo;
import com.github.rapidark.framework.utility.DateUtil;
import com.github.rapidark.framework.utility.FileUtil;
import com.github.rapidark.framework.utility.LogUtil;
import com.github.rapidark.framework.utility.ObjectUtil;
import com.github.rapidark.framework.utility.StringFormat;
import com.github.rapidark.framework.utility.StringUtil;

public class LicenseInfo {
	
	public static boolean isLicenseValidity = false;
	public static boolean isMacAddressValidity = false;
	public static boolean isFrontDeployLicense = false;
	public static String Name;
	public static String Product;
	public static String MacAddress;
	public static String HardwareID;
	public static int UserLimit;
	public static int OtherLimit;
	public static Date EndDate;
	public static Mapx<String, String> PluginMap;
	static String cert = "MIICQzCCAaygAwIBAgIGATaV7VGjMA0GCSqGSIb3DQEBBQUAMGQxCzAJBgNVBAYTAkNOMRAwDgYDVQQIDAdCRUlKSU5HMRAwDgYDVQQHDAdIQUlESUFOMQ4wDAYDVQQKDAVaVklORzENMAsGA1UECwwEU09GVDESMBAGA1UEAwwJTGljZW5zZUNBMCAXDTEyMDQwOTA3MDY1OVoYDzIxMTIwNDA5MDcwNjU5WjBkMQswCQYDVQQGEwJDTjEQMA4GA1UECAwHQkVJSklORzEQMA4GA1UEBwwHSEFJRElBTjEOMAwGA1UECgwFWlZJTkcxDTALBgNVBAsMBFNPRlQxEjAQBgNVBAMMCUxpY2Vuc2VDQTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAocWNmvoyaPlaG6oKafrNlaYM+jZyELtK1c/GRyfmSbv+HBlOo5fZ8MEpsLfMJKyUk+QjVBNNhot8jc96MC8PcBU6QZ0HZwhnyniBYkXO8VjQ4g3A6p5X6NPYn+FFvMg/jn0lP0bG/vOoLgVrsvqJInKLFsXEYhKHxChK1Vcc3nECAwEAATANBgkqhkiG9w0BAQUFAAOBgQAl8tEOIPtgGpM3Y7F24QEAcwCgyEwdaMZ+Cfmq2ud1rPtbYKmA4FfAHH1ttCpBIMwNz1RRVk98Rp9MqF3OuGCICz/amewOQW6Y3wwTiyA40geN1MYyGgp80K1u71G24gV9qY9GddLS5ZIecmVtj/J22jY2oktYfRwnhbXQ+elq/Q==";

	public static synchronized void init() {
		if (Name == null) {
			update();
		}
	}

	public static synchronized void update() {
		try {
			byte[] code = StringUtil.hexDecode(
					FileUtil.readText(Config.getPluginPath() + "classes/license.dat").replaceAll("\\s+", "").trim());
			JDKX509CertificateFactory certificatefactory = new JDKX509CertificateFactory();
			X509Certificate cer = (X509Certificate) certificatefactory
					.engineGenerateCertificate(new ByteArrayInputStream(StringUtil.base64Decode(cert)));
			PublicKey pubKey = cer.getPublicKey();
			ZRSACipher dc = new ZRSACipher();
			dc.init(2, pubKey);
			byte[] bs = new byte[code.length * 2];
			int indexBS = 0;
			int indexCode = 0;
			while (code.length - indexCode > 128) {
				indexBS += dc.doFinal(code, indexCode, 128, bs, indexBS);
				indexCode += 128;
			}
			indexBS += dc.doFinal(code, indexCode, code.length - indexCode, bs, indexBS);
			String str = new String(bs, 0, indexBS, "UTF-8");
			Mapx<String, String> map = StringUtil.splitToMapx(str, ";", "=");
			Name = map.getString("Name");
			Product = map.getString("Product");
			UserLimit = Integer.parseInt(map.getString("UserLimit"));
			OtherLimit = map.getInt("OtherLimit");
			MacAddress = map.getString("MacAddress");
			HardwareID = map.getString("HardwareID");
			EndDate = DateUtil.parse("3000-01-01");// map.getString("EndDate"));
			isFrontDeployLicense = map.getBoolean("isFrontDeployLicense");
			PluginMap = map;
			if (isFrontDeployLicense) {
				Config.setFrontDeploy(true);
			}
			isLicenseValidity = EndDate.getTime() > System.currentTimeMillis();
			if ((Name.indexOf("TrailUser") >= 0) || (MacAddress.equals(SystemInfo.getMacAddress()))) {
				isMacAddressValidity = true;
			} else {
				LogUtil.error("Mac address not licensed!");
				// System.exit(0);
			}
			if ((Name.indexOf("TrailUser") < 0) && (!HardwareID.equals(retireHardwareID()))) {
				System.out.println(HardwareID + "\t" + retireHardwareID());
				LogUtil.error("HardwareID not licensed!");
				// System.exit(0);
			}
			if (!isLicenseValidity) {
				LogUtil.error("License is out of date!");
			}
			for (PluginConfig pc : PluginManager.getInstance().getAllPluginConfig()) {
				if (("1".equals(Product)) && ("Y".equals(map.get("Plugin_" + pc.getID())))) {
					ExtendManager.getInstance().stopPlugin(pc);
				}
				if ("N".equals(map.get("Plugin_" + pc.getID()))) {
					ExtendManager.getInstance().stopPlugin(pc);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			LogUtil.error("Exception found when checking license:" + e.getMessage());
			// System.exit(0);
		}
	}

	public static String getLicenseRequest(String customer) {
		try {
			JDKX509CertificateFactory certificatefactory = new JDKX509CertificateFactory();
			X509Certificate cer = (X509Certificate) certificatefactory
					.engineGenerateCertificate(new ByteArrayInputStream(StringUtil.base64Decode(cert)));
			PublicKey pubKey = cer.getPublicKey();
			ZRSACipher ec = new ZRSACipher();
			ec.init(1, pubKey);
			StringFormat sf = new StringFormat("Name=?;MacAddress=?;HardwareID=?");
			if (Config.getGlobalCharset().equals("GBK")) {
				customer = new String(StringUtil.GBKToUTF8(customer), "UTF-8");
			}
			sf.add(customer);
			sf.add(SystemInfo.getMacAddress());
			sf.add(retireHardwareID());
			byte[] bs = sf.toString().getBytes("UTF-8");
			byte[] code = new byte[((bs.length - 1) / 117 + 1) * 128];
			int indexBS = 0;
			int indexCode = 0;
			while (bs.length - indexBS > 117) {
				indexCode += ec.doFinal(bs, indexBS, 117, code, indexCode);
				indexBS += 117;
			}
			ec.doFinal(bs, indexBS, bs.length - indexBS, code, indexCode);
			return StringUtil.hexEncode(code);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public static boolean verifyLicense(String license) {
		try {
			byte[] code = StringUtil.hexDecode(license.replaceAll("\\s+", "").trim());
			JDKX509CertificateFactory certificatefactory = new JDKX509CertificateFactory();
			X509Certificate cer = (X509Certificate) certificatefactory
					.engineGenerateCertificate(new ByteArrayInputStream(StringUtil.base64Decode(cert)));
			PublicKey pubKey = cer.getPublicKey();
			ZRSACipher dc = new ZRSACipher();
			dc.init(2, pubKey);
			byte[] bs = new byte[code.length * 2];
			int indexBS = 0;
			int indexCode = 0;
			while (code.length - indexCode > 128) {
				indexBS += dc.doFinal(code, indexCode, 128, bs, indexBS);
				indexCode += 128;
			}
			indexBS += dc.doFinal(code, indexCode, code.length - indexCode, bs, indexBS);
			return true;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return true;
	}

	public static boolean isMacAddressValidity() {
		init();
		// return isMacAddressValidity;
		return true;
	}

	public static boolean isLicenseValidity() {
		init();
		return true;// return isLicenseValidity;
	}

	public static String getName() {
		init();
		return Name;
	}

	public static String getProduct() {
		init();
		return Product;
	}

	public static int getUserLimit() {
		init();
		return UserLimit;
	}

	public static int getOtherLimit() {
		init();
		return OtherLimit;
	}

	public static Date getEndDate() {
		init();
		return EndDate;
	}

	public static String getMacAddress() {
		init();
		return MacAddress;
	}

	public static String retireHardwareID() {
		String os = System.getProperty("os.name").toLowerCase();
		String output = null;
		try {
			if (os.indexOf("windows") < 0) {
				output = FileUtil.readText("/proc/cpuinfo");
				List<String> list = new ArrayList();
				String[] arrayOfString;
				int j = (arrayOfString = output.split("\\n")).length;
				for (int i = 0; i < j; i++) {
					String line = arrayOfString[i];
					line = line.toLowerCase();
					if ((line.startsWith("vendor")) || (line.startsWith("cpu family")) || (line.startsWith("model"))) {
						list.add(line);
					}
				}
				list = ObjectUtil.sort(list, ObjectUtil.ASCStringComparator);
				output = StringUtil.join(list.toArray());
				output = StringUtil.md5Hex(output).substring(0, 8);
			} else {
				String cmd = "wmic cpu get processorid";
				Process proc = Runtime.getRuntime().exec(cmd);
				proc.getOutputStream().close();
				InputStream is = proc.getInputStream();
				output = FileUtil.readText(is, Config.getFileEncode());
				if (output.indexOf("\n") > 0) {
					output = output.substring(output.indexOf("\n") + 1);
				}
				output = output.replaceAll("\\s", "");
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			LogUtil.error("Get Hardware ID Failed:OS=" + os);
		}
		return output.toUpperCase();
	}

	public static String generateRequestSN() throws Exception {
		String mac = SystemInfo.getMacAddress();
		String cpu = retireHardwareID();
		String str = mac + "," + cpu;
		str = StringUtil.replaceEx(str, "-", "");
		str = StringUtil.replaceEx(str, ",", "G");
		BigInteger t = new BigInteger(str, 17);
		str = t.toString(36).toUpperCase();
		StringBuilder sb = new StringBuilder();
		int p = 5;
		for (int i = 0; i * p < str.length(); i++) {
			if (i != 0) {
				sb.append("-");
			}
			int end = i * p + p;
			if (end > str.length()) {
				end = str.length();
			}
			sb.append(str.substring(i * p, end));
		}
		return sb.toString();
	}

	public static void main(String[] args) throws Exception {
		System.out.println(generateRequestSN());
	}
}
