package com.github.rapidark.framework.utility;

import java.io.File;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;

import com.github.rapidark.framework.Config;
import com.github.rapidark.framework.collection.Mapx;
import com.github.rapidark.framework.core.FrameworkException;
import com.github.rapidark.framework.utility.FileUtil;
import com.github.rapidark.framework.utility.StringUtil;
import com.github.rapidark.framework.utility.log.ILogManager;
import com.github.rapidark.framework.utility.log.ILogger;

public class Log4jManager
  implements ILogManager
{
  ILogger console = null;
  ILogger error = null;
  ILogger cron = null;
  
  public Log4jManager()
  {
    String fileName = Config.getPluginPath() + "classes/log4j.config";
    String txt = null;
    if (new File(fileName).exists()) {
      txt = FileUtil.readText(fileName);
    }
    if (StringUtil.isNotEmpty(txt))
    {
      txt = StringUtil.replaceEx(txt, "%{ContextRealPath}", Config.getContextRealPath());
      Mapx<String, String> map = StringUtil.splitToMapx(txt, "\n", "=");
      Properties ps = new Properties();
      for (Map.Entry<String, String> entry : map.entrySet())
      {
        String key = (String)entry.getKey();
        if ((!StringUtil.isEmpty(key)) && (!key.startsWith("#"))) {
          ps.put(key, ((String)entry.getValue()).trim());
        }
      }
      PropertyConfigurator.configure(ps);
      this.cron = new Log4jLogger(LogFactory.getLog("cronLogger"));
      this.console = new Log4jLogger(LogFactory.getLog("consoleLogger"));
      this.error = new Log4jLogger(LogFactory.getLog("errorLogger"));
    }
    else
    {
      throw new FrameworkException("Load Log4jManager failed!");
    }
  }
  
  public ILogger getConsoleLogger()
  {
    return this.console;
  }
  
  public ILogger getErrorLogger()
  {
    return this.error;
  }
  
  public ILogger getCronLogger()
  {
    return this.cron;
  }
}
