/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver;

import com.github.restdriver.serverdriver.http.exception.RuntimeMappingException;
import com.github.restdriver.serverdriver.http.response.Response;
import com.github.restdriver.serverdriver.matchers.ContainingValue;
import com.github.restdriver.serverdriver.matchers.HasJsonArray;
import com.github.restdriver.serverdriver.matchers.HasJsonValue;
import com.github.restdriver.serverdriver.matchers.WithSize;
import com.github.restdriver.serverdriver.matchers.WithValueAt;
import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class Json {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private Json() {
    }

    public static JsonNode asJson(Response response) {
        return Json.asJson(response.getContent());
    }

    public static JsonNode asJson(String json) {
        try {
            return MAPPER.readTree(json);
        }
        catch (IOException e) {
            throw new RuntimeMappingException("Failed to create JSON node", e);
        }
    }

    public static TypeSafeMatcher<JsonNode> hasJsonValue(String fieldName, Matcher<?> matcher) {
        return new HasJsonValue(fieldName, matcher);
    }

    public static TypeSafeMatcher<JsonNode> hasJsonArray(String fieldName, Matcher<?> matcher) {
        return new HasJsonArray(fieldName, matcher);
    }

    public static TypeSafeMatcher<JsonNode> containingValue(Matcher<?> matcher) {
        return new ContainingValue(matcher);
    }

    public static TypeSafeMatcher<JsonNode> withValueAt(int position, Matcher<?> matcher) {
        return new WithValueAt(position, matcher);
    }

    public static TypeSafeMatcher<JsonNode> withSize(Matcher<?> matcher) {
        return new WithSize(matcher);
    }
}

