/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver;

import com.github.restdriver.serverdriver.http.Header;
import com.github.restdriver.serverdriver.http.response.Response;
import com.github.restdriver.serverdriver.matchers.HasHeader;
import com.github.restdriver.serverdriver.matchers.HasHeaderWithValue;
import com.github.restdriver.serverdriver.matchers.HasResponseBody;
import com.github.restdriver.serverdriver.matchers.HasStatusCode;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class Matchers {
    private Matchers() {
    }

    public static TypeSafeMatcher<Response> hasStatusCode(int statusCode) {
        return new HasStatusCode((Matcher<Integer>)org.hamcrest.Matchers.is((Object)statusCode));
    }

    public static TypeSafeMatcher<Response> hasStatusCode(Matcher<Integer> statusCodeMatcher) {
        return new HasStatusCode(statusCodeMatcher);
    }

    public static TypeSafeMatcher<Response> hasResponseBody(Matcher<String> bodyMatcher) {
        return new HasResponseBody(bodyMatcher);
    }

    public static TypeSafeMatcher<Response> hasHeader(String header) {
        if (header.indexOf(":") != -1) {
            return Matchers.hasHeader(new Header(header));
        }
        return new HasHeader(header);
    }

    public static TypeSafeMatcher<Response> hasHeader(Header header) {
        return Matchers.hasHeader(header.getName(), header.getValue());
    }

    public static TypeSafeMatcher<Response> hasHeader(String name, String value) {
        return new HasHeaderWithValue(name, (Matcher<String>)org.hamcrest.Matchers.equalTo((Object)value));
    }

    public static TypeSafeMatcher<Response> hasHeader(String name, Matcher<String> valueMatcher) {
        return new HasHeaderWithValue(name, valueMatcher);
    }

    public static TypeSafeMatcher<Response> hasHeaderWithValue(String name, Matcher<String> valueMatcher) {
        return new HasHeaderWithValue(name, valueMatcher);
    }
}

