/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver;

import com.github.restdriver.serverdriver.http.Header;
import com.github.restdriver.serverdriver.http.RequestBody;
import com.github.restdriver.serverdriver.http.RequestModifier;
import com.github.restdriver.serverdriver.http.exception.RuntimeHttpHostConnectException;
import com.github.restdriver.serverdriver.http.exception.RuntimeUnknownHostException;
import com.github.restdriver.serverdriver.http.response.DefaultResponse;
import com.github.restdriver.serverdriver.http.response.Response;
import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public final class RestServerDriver {
    private static final int DEFAULT_HTTP_TIMEOUT_MS = 10000;

    private RestServerDriver() {
    }

    public static Header header(String name, String value) {
        return new Header(name, value);
    }

    public static Header header(String nameAndValue) {
        return new Header(nameAndValue);
    }

    public static RequestBody body(String content, String contentType) {
        return new RequestBody(content, contentType);
    }

    public static Response options(Object url) {
        HttpOptions request = new HttpOptions(url.toString());
        return RestServerDriver.doHttpRequest((HttpUriRequest)request);
    }

    public static Response optionsOf(Object url) {
        return RestServerDriver.options(url);
    }

    public static Response get(Object url, Header ... headers) {
        HttpGet request = new HttpGet(url.toString());
        RestServerDriver.applyModifiersToRequest(headers, (HttpUriRequest)request);
        return RestServerDriver.doHttpRequest((HttpUriRequest)request);
    }

    public static Response getOf(Object url, Header ... headers) {
        return RestServerDriver.get(url, headers);
    }

    public static Response doGetOf(Object url, Header ... headers) {
        return RestServerDriver.get(url, headers);
    }

    public static Response getting(Object url, Header ... headers) {
        return RestServerDriver.get(url, headers);
    }

    public static Response post(Object url, RequestModifier ... modifiers) {
        HttpPost request = new HttpPost(url.toString());
        RestServerDriver.applyModifiersToRequest(modifiers, (HttpUriRequest)request);
        return RestServerDriver.doHttpRequest((HttpUriRequest)request);
    }

    public static Response postOf(Object url, RequestModifier ... modifiers) {
        return RestServerDriver.post(url, modifiers);
    }

    public static Response doPostOf(Object url, RequestModifier ... modifiers) {
        return RestServerDriver.post(url, modifiers);
    }

    public static Response posting(Object url, RequestModifier ... modifiers) {
        return RestServerDriver.post(url, modifiers);
    }

    public static Response put(Object url, RequestModifier ... modifiers) {
        HttpPut request = new HttpPut(url.toString());
        RestServerDriver.applyModifiersToRequest(modifiers, (HttpUriRequest)request);
        return RestServerDriver.doHttpRequest((HttpUriRequest)request);
    }

    public static Response putOf(Object url, RequestModifier ... modifiers) {
        return RestServerDriver.put(url, modifiers);
    }

    public static Response doPutOf(Object url, RequestModifier ... modifiers) {
        return RestServerDriver.put(url, modifiers);
    }

    public static Response putting(Object url, RequestModifier ... modifiers) {
        return RestServerDriver.put(url, modifiers);
    }

    public static Response delete(Object url, Header ... headers) {
        HttpDelete request = new HttpDelete(url.toString());
        RestServerDriver.applyModifiersToRequest(headers, (HttpUriRequest)request);
        return RestServerDriver.doHttpRequest((HttpUriRequest)request);
    }

    public static Response deleteOf(Object url, Header ... headers) {
        return RestServerDriver.delete(url, headers);
    }

    public static Response doDeleteOf(Object url, Header ... headers) {
        return RestServerDriver.delete(url, headers);
    }

    public static Response deleting(Object url, Header ... headers) {
        return RestServerDriver.delete(url, headers);
    }

    private static void applyModifiersToRequest(RequestModifier[] modifiers, HttpUriRequest request) {
        if (modifiers == null) {
            return;
        }
        for (RequestModifier modifier : modifiers) {
            modifier.applyTo(request);
        }
    }

    private static Response doHttpRequest(HttpUriRequest request) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpParams httpParams = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)10000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)0);
        HttpClientParams.setRedirecting((HttpParams)httpParams, (boolean)false);
        try {
            long startTime = System.currentTimeMillis();
            HttpResponse response = httpClient.execute(request);
            long endTime = System.currentTimeMillis();
            return new DefaultResponse(response, endTime - startTime);
        }
        catch (UnknownHostException uhe) {
            throw new RuntimeUnknownHostException(uhe);
        }
        catch (HttpHostConnectException hhce) {
            throw new RuntimeHttpHostConnectException(hhce);
        }
        catch (IOException e) {
            throw new RuntimeException("Error executing request", e);
        }
    }
}

