/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.file;

import com.github.restdriver.serverdriver.file.RuntimeFileNotFoundException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public final class FileHelper {
    private static final String DEFAULT_ENCODING = "UTF-8";

    private FileHelper() {
    }

    public static String fromFile(String fileName, String encoding) {
        InputStream stream = FileHelper.class.getClassLoader().getResourceAsStream(fileName);
        if (stream == null) {
            throw new RuntimeFileNotFoundException(new FileNotFoundException(fileName));
        }
        try {
            return IOUtils.toString((InputStream)stream, (String)encoding);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read from file " + fileName, e);
        }
    }

    public static String fromFile(String fileName) {
        return FileHelper.fromFile(fileName, DEFAULT_ENCODING);
    }
}

