/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.http;

import com.github.restdriver.serverdriver.http.RequestModifier;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public final class RequestBody
implements RequestModifier {
    private static final String DEFAULT_CONTENT_ENCODING = "UTF-8";
    private final String content;
    private final String contentType;

    public RequestBody(String content, String contentType) {
        this.content = content;
        this.contentType = contentType;
    }

    public String getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void applyTo(HttpUriRequest request) {
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            return;
        }
        HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)request;
        entityRequest.setHeader("Content-type", this.contentType);
        try {
            entityRequest.setEntity((HttpEntity)new StringEntity(this.content, this.contentType, DEFAULT_CONTENT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error setting entity of request", e);
        }
    }
}

