/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.serverdriver.http.response;

import com.github.restdriver.serverdriver.Json;
import com.github.restdriver.serverdriver.Xml;
import com.github.restdriver.serverdriver.http.Header;
import com.github.restdriver.serverdriver.http.response.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.codehaus.jackson.JsonNode;
import org.w3c.dom.Element;

public final class DefaultResponse
implements Response {
    private final int statusCode;
    private final String content;
    private final List<Header> headers;
    private final long responseTime;

    public DefaultResponse(HttpResponse response, long responseTime) {
        this.statusCode = response.getStatusLine().getStatusCode();
        this.content = DefaultResponse.contentFromResponse(response);
        this.headers = DefaultResponse.headersFromResponse(response);
        this.responseTime = responseTime;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public List<Header> getHeaders() {
        return this.headers;
    }

    @Override
    public List<Header> getHeaders(String headerName) {
        ArrayList<Header> matchingHeaders = new ArrayList<Header>();
        for (Header header : this.headers) {
            if (!header.getName().equalsIgnoreCase(headerName)) continue;
            matchingHeaders.add(header);
        }
        return matchingHeaders;
    }

    @Override
    public Header getHeader(String headerName) {
        List<Header> matchingHeaders = this.getHeaders(headerName);
        if (matchingHeaders.isEmpty()) {
            return null;
        }
        if (matchingHeaders.size() > 1) {
            throw new IllegalStateException("Attempt to get single header '" + headerName + "' but more than one value found.");
        }
        return matchingHeaders.get(0);
    }

    @Override
    public long getResponseTime() {
        return this.responseTime;
    }

    @Override
    public JsonNode asJson() {
        return Json.asJson(this);
    }

    @Override
    public Element asXml() {
        return Xml.asXml(this.getContent());
    }

    public String toString() {
        return "status=" + this.statusCode + "|content=" + this.content + "|headers=[" + StringUtils.join(this.headers, (String)",") + "]";
    }

    private static String contentFromResponse(HttpResponse response) {
        String content;
        InputStream stream;
        block5: {
            stream = null;
            try {
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    content = null;
                    break block5;
                }
                stream = response.getEntity().getContent();
                content = IOUtils.toString((InputStream)stream, (String)"UTF-8");
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Error getting response entity", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        return content;
    }

    private static List<Header> headersFromResponse(HttpResponse response) {
        ArrayList<Header> headers = new ArrayList<Header>();
        for (org.apache.http.Header currentHeader : response.getAllHeaders()) {
            Header header = new Header(currentHeader.getName(), currentHeader.getValue());
            headers.add(header);
        }
        return headers;
    }
}

